require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local brighteyes = {}

brighteyes.renderObject = nil;
brighteyes.queue = 100;
brighteyes.eyesmask = nil;
brighteyes.strengh = 0.5;
brighteyes.brightscale = 8;

function brighteyes:Initialize(host, size)
  self.Stepsize1 = mathfunction.vector2(5, 5);
  self.Stepsize2 = mathfunction.vector2(5, 5);
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
  
  self.TEXTURE_EYEMASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_EYEMASK");
  self.TEXTURE_ORIGIN = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_ORIGIN");
  self.UNIFORM_STRENGTH = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_STRENGTH");
  self.UNIFORM_BRIGHTSCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_BRIGHTSCALE");
  
    
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  self.EyeGuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.EyeGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0) );
  
  self.EyeGuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.EyeGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y()) );
  
  self.RoGuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), 0) );
  
  self.RoGuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
  self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep2:y()) );
  
  self.Blend = host:CreateRenderObject( "comm:documents/material/brighteyeblend.material" );
  self.Blend:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
  self.Blend:SetParameter( self.UNIFORM_BRIGHTSCALE, mathfunction.vector1(self.brightscale) );
  
  self.blurXRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.blurYRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );
  self.blurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, size );
  return self.queue;
end

function brighteyes:Resizeview(size)
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  self.Stepsize2 = mathfunction.vector2(2, 2);
  self.size = size;
  self.EyeGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), 0 ) );
  self.EyeGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep1:y() ) );
  self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), 0 ) );
  self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep2:y() ) );
end

function brighteyes:Process(pipeline, Original, Scene, Output)
  
  self:_UpdateParameters();
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  
  self.blurXRT:PushRenderTarget();
	self.blurXRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.EyeGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.eyesmask);
	self.EyeGuassX:Draw(pipeline);
  
  self.blurYRT:PushRenderTarget();
  self.blurYRT:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.EyeGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.blurXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.EyeGuassY:Draw(pipeline);
  local eyemask = self.blurYRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 );
  
  self.blurXRT:PushRenderTarget();
	self.blurXRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		origintexture);
	self.RoGuassX:Draw(pipeline);
  
  self.blurRT:PushRenderTarget();
	self.blurRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.blurXRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
	self.RoGuassY:Draw(pipeline);
  
  self.Blend:SetParameter(self.TEXTURE_ORIGIN,origintexture);
  self.Blend:SetParameter(self.TEXTURE_EYEMASK,eyemask);
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.Blend:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.blurRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.Blend:Draw(pipeline);
  
end

function brighteyes:_UpdateParameters()
  self.Blend:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
end

return brighteyes;