


local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local alphachange = {}
alphachange.Do = 0;
alphachange.Queue = 310;

function alphachange:Initialize(host, size)
  
  self.Zoomscale = 50.0;
  self.AlphaValue = 0.5;
  self.AlphaXYoffsest = mathfunction.vector2(0.0,0.0);
  
  self.ALPHA_ZOOMSCALE = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "ALPHA_ZOOMSCALE");  
    
  self.ALPHA_ALPHAVALUE = apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,
      "ALPHA_ALPHAVALUE");  
    
    
  self.ALPHA_XYOFFSET = apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,
      "ALPHA_XYOFFSET");    
    
    
  self:CreateInitVal(host,size);

  return self.Queue;
  
end









function alphachange:CreateInitVal(host,size)
  
  local alphachangePath = venuscore.IFileSystem:PathAssembly("comm:documents/material/alphachange.material"); 
  self.alphachange = host:CreateRenderObject( alphachangePath);
  self.alphachange:SetParameter(self.ALPHA_ZOOMSCALE, mathfunction.vector1(self.Zoomscale));
  self.alphachange:SetParameter(self.ALPHA_ALPHAVALUE, mathfunction.vector1(self.AlphaValue));
  self.alphachange:SetParameter(self.ALPHA_XYOFFSET, self.AlphaXYoffsest);

  local targetsize = size;
  
  host:RegisterScriptParameter(self, "Zoomscale");
  host:RegisterScriptParameter(self, "AlphaValue");
  host:RegisterScriptParameter(self, "AlphaXYoffsest");

end

function alphachange:Resizeview(size)

end


function alphachange:Process(pipeline, Original, Scene, Output)
  
  self:_UpdateParameters();
  
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR_DEPTH_STENCIL);
  self.alphachange:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0));
  self.alphachange:Draw(pipeline);
    
end

function alphachange:_UpdateParameters()
  self.alphachange:SetParameter(self.ALPHA_ZOOMSCALE,   mathfunction.vector1(self.Zoomscale));
  self.alphachange:SetParameter(self.ALPHA_ALPHAVALUE, mathfunction.vector1(self.AlphaValue));
  self.alphachange:SetParameter(self.ALPHA_XYOFFSET,  mathfunction.vector2(self.AlphaXYoffsest:x(),self.AlphaXYoffsest:y()));
end

return alphachange;
