local apollocore = require "apollocore"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"

function apollocore.SDFTextNode:RenderText()
  local uvlist = self:GetUVList(self.Text);
  -- 生成顶点数据用于映射上面生成的图片
  local vertexstream = apollocore.VertexStream();
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_POSITION,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 2);
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 2);
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_COLOR0,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 4);
  --创建索引流
  local indicesstream = apollocore.IndicesStream();
  indicesstream:SetIndicesType(
          apollocore.IndicesBufferEntity.IT_UINT16);
  local x = 0;
  local y = 0;
  local index = 0;
  local color = mathfunction.vector4(1,1,1,1);
  for i, glyph in ipairs(uvlist) do
    local  xpos = x;
    local ypos = y;
    local w = glyph.width;
    local h = glyph.height;
    local italicOffset = 0;
    if self.Italic then
      italicOffset = h * math.tan(math.pi/6.0);
      LOG(italicOffset);
    end
    -- lefttop
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + italicOffset, ypos + h));
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.x/512.0, glyph.y/512.0));
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COLOR0, color);
    -- leftbottom
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos, ypos));
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.x/512.0, (glyph.y + h)/512.0));
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COLOR0, color);
    -- righttop
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + w + italicOffset, ypos + h));
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2((glyph.x + w)/512.0, glyph.y/512.0));
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COLOR0, color);
    -- rightbottom
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + w, ypos));
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2((glyph.x + w)/512.0, (glyph.y + h)/512.0));
    vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COLOR0, color);
    -- 顶点数据
    indicesstream:PushIndicesData(0 + 4 * index);
    indicesstream:PushIndicesData(1 + 4 * index);
    indicesstream:PushIndicesData(2 + 4 * index);
    indicesstream:PushIndicesData(2 + 4 * index);
    indicesstream:PushIndicesData(1 + 4 * index);
    indicesstream:PushIndicesData(3 + 4 * index);
    index = index + 1;
    --字间距和文字框的最大宽度，目前没有换行的功能，高度按照字体的大小来决定
    x = x + glyph.width;
  end
  local render = self:GetComponent(apollocore.Node.CT_RENDER);
  render:ChangeVertexBuffer(vertexstream);
  render:ChangeIndexBuffer(indicesstream);
  render:SetDrawCount(indicesstream:GetIndicesCount());
end

return apollocore.SDFTextNode;