local apollocore = require "apollocore"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"

if _KRATOSEDITOR then
  local fbxfunc = require "fbxtool"

  local _fNativeOnSerializeStarted = apollocore.AnimationComponent.OnSerializeStarted;
  assert(_fNativeOnSerializeStarted);


  function apollocore.AnimationComponent:OnSerializeStarted()
      local saveInfos = self:GetSaveCurvesInfo();
      fbxfunc.FbxTool:AddAnimationSaveInfo(saveInfos);
  end
end


local stringPlay = "Play"

rawset(
  apollocore.AnimationComponent,
  "GetProperties",
  function(self, typeName)
    local res = apollocore.IContent.GetProperties(self, typeName); --先取得其余的属性
    table.insert(res, stringPlay);
    return res;
  end
);

rawset(
  apollocore.AnimationComponent,
  "GetScriptPropValue",
  function(self, prop)
    if prop == stringPlay then
      local status = self:GetAnimationStatus()
      return status == apollocore.IComponent.AS_PLAYING
    end
    return apollocore.IContent.GetScriptPropValue(self, prop);
  end
);

rawset(
  apollocore.AnimationComponent,
  "SetScriptPropValue",
  function(self, prop, value)
    if prop == stringPlay then
      if value then
        self:Play()
      else
        self:Stop()
        self:Reset()
      end      
    else
      apollocore.IContent.SetScriptPropValue(self, prop, value);
    end
  end
);

local gLastEvent = {}
local _fNativeDestroy = apollocore.IComponent.Destroy;
rawset(apollocore.AnimationComponent, "Destroy", function(self)
  local staticID =  self:GetContentPath();
  --for id, _ in pairs(gLastEvent) do
  --  ERROR("Animation LastEvent staticID: "..tostring(id))
  --end
  gLastEvent[staticID] = nil
  _fNativeDestroy(self);
end);

rawset(apollocore.AnimationComponent, "ResetCached", function(self)
  local staticID =  self:GetContentPath();
  gLastEvent[staticID] = nil
end);

local function ClearTimelineEvents(staticID)
  gLastEvent[staticID] = gLastEvent[staticID] or {};
  for k,v in pairs(gLastEvent[staticID]) do
    if string.startsWith(k,BlueDefined.Event.AnimationEvent.Trigger) then
      gLastEvent[staticID][k] = false;
    end
  end
end

local function TimelineListening(status, staticID, eventType)
  if status then --有状态
    if gLastEvent[staticID] and gLastEvent[staticID][eventType] then
      local event = {
        staticID = staticID,
        eventType = eventType,
        params = {
          isEdge = false --当前触发不是边缘触发
        }
      };
      EventDispatcher:PushEvent(event);
    else
      ClearTimelineEvents(staticID);
      gLastEvent[staticID][eventType] = true;
      local event = {
        staticID = staticID,
        eventType = eventType,
        params = {
          isEdge = true --当前触发是边缘触发
        }
      };
      EventDispatcher:PushEvent(event);
    end
  else
    ClearTimelineEvents(staticID);
  end
end

local function Listening(status, staticID, eventType,curveName)
  if EventDispatcher:HasEventListener(staticID, eventType) then
    if status then --有状态
      if gLastEvent[staticID] and gLastEvent[staticID][eventType] and gLastEvent[staticID][curveName] then
        local event = {
        staticID = staticID,
        eventType = eventType,
        params = {
          isEdge = false, --当前触发不是边缘触发
          aniName = curveName
        }
        };
        EventDispatcher:PushEvent(event);
      else
        gLastEvent[staticID] = gLastEvent[staticID] or {};
        gLastEvent[staticID][eventType] = true;
        gLastEvent[staticID][curveName] = true;  --判断是不是边缘触发的逻辑加上动画名称(目前是动画文件路径)
        local event = {
        staticID = staticID,
        eventType = eventType,
        params = {
          isEdge = true, --当前触发是边缘触发
          aniName = curveName;
        }
        };
        EventDispatcher:PushEvent(event);
      end  
    else --没状态不触发并且清空掉东西
      gLastEvent[staticID] = gLastEvent[staticID] or {};
      gLastEvent[staticID][eventType] = false;
      gLastEvent[staticID][curveName] = false;
    end  
  end
end


--EventDispatcher:RegisterEvent(apollocore.AnimationComponent:GetTypeName(), BlueDefined.Event.AnimationEvent.Play);
--EventDispatcher:RegisterEvent(apollocore.AnimationComponent:GetTypeName(), BlueDefined.Event.AnimationEvent.Stop);
--EventDispatcher:RegisterEvent(apollocore.AnimationComponent:GetTypeName(), BlueDefined.Event.AnimationEvent.End);
local _fNativeUpdate = apollocore.IComponent.Update;
local UpdateFunc = function(self, def)
  _fNativeUpdate(self, def);
  local status = self:GetAnimationStatus();
  local currentFrameID = self:GetCurrentFrameID();
  --LOG(currentFrameID)
  local isPlaying = status == apollocore.IComponent.AS_PLAYING;
  local hasDone = status == apollocore.IComponent.AS_DONE;
  local hasStopped = status == apollocore.IComponent.AS_STOP;
  local staticID = self:GetContentPath();
  local aniName = self:GetCurrentAnimationName();
  local frameEvent = BlueDefined.Event.AnimationEvent.Trigger .. currentFrameID;
  if EventDispatcher:HasCompListener(staticID) then--不是蓝图里面注册的监听就不要触发
    Listening(isPlaying, staticID, BlueDefined.Event.AnimationEvent.Play,aniName);
    Listening(hasDone, staticID, BlueDefined.Event.AnimationEvent.End,aniName);
    Listening(hasStopped, staticID, BlueDefined.Event.AnimationEvent.Stop,aniName);
    local frameArrived = EventDispatcher:HasEventListener(staticID, frameEvent,aniName);
    TimelineListening(frameArrived, staticID, frameEvent);
  end
end
rawset(apollocore.AnimationComponent,"Update",UpdateFunc)

