--local apolloengine = require "apolloengine"
local cv = require "computervisionfunction"
local utility = require "utility"
local DeviceResource = require "apolloengine.deviceresource"


local fNativeUpdate = cv.AIMorphComponent.Update;
local fNativeStart = cv.AIMorphComponent.Start;

local UpdateFoo = function (self,dt)
  if not self:isStarted() then
    self:Start(); --编辑期增加component时调用
  end    
  fNativeUpdate(self, dt);
end

local StartFoo = function (self)  --素材反序列化以后Node:Start()调用
  local tex = self:GetStyleResult();
  DeviceResource:PushDeviceResource(
          DeviceResource.DEVICE_AIMORPH,
          tex);
  fNativeStart(self);
end

--此处必须用rawset，否则会把UPDATE函数设置到cv.StyleTransferComponent的元表的UPDATE中。
rawset(cv.AIMorphComponent,"Update",UpdateFoo)
rawset(cv.AIMorphComponent,"Start",StartFoo)
