

function DefineParams()
	Properties = 
	{
		
TEXELSIZE = { "TexelSize", VEC2, "0.0,0.0" },
BLOOM_THRESHOLD = { "BloomThreshold", FLOAT, "0.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "SuperMeBlurT"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXELSIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BLOOM_THRESHOLD",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec2 TEXELSIZE;
uniform highp float BLOOM_THRESHOLD;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp float alpha_1;
  lowp vec4 out_SurfaceColor_2;
  highp vec2 aroundCoord_0_3;
  highp vec2 aroundCoord_1_4;
  highp vec2 aroundCoord_2_5;
  highp vec2 aroundCoord_3_6;
  highp vec4 tmpvar_7;
  tmpvar_7.xy = -(TEXELSIZE);
  tmpvar_7.z = TEXELSIZE.x;
  tmpvar_7.w = TEXELSIZE.y;
  aroundCoord_0_3 = (xlv_TEXCOORD0 + tmpvar_7.xy);
  aroundCoord_1_4 = (xlv_TEXCOORD0 + tmpvar_7.zy);
  aroundCoord_2_5 = (xlv_TEXCOORD0 + tmpvar_7.xw);
  aroundCoord_3_6 = (xlv_TEXCOORD0 + TEXELSIZE);
  out_SurfaceColor_2 = (texture (TEXTURE_DIFFUSE, aroundCoord_0_3) + texture (TEXTURE_DIFFUSE, aroundCoord_1_4));
  out_SurfaceColor_2 = (out_SurfaceColor_2 + texture (TEXTURE_DIFFUSE, aroundCoord_2_5));
  out_SurfaceColor_2 = (out_SurfaceColor_2 + texture (TEXTURE_DIFFUSE, aroundCoord_3_6));
  out_SurfaceColor_2 = (out_SurfaceColor_2 * 0.25);
  lowp float tmpvar_8;
  tmpvar_8 = dot (out_SurfaceColor_2.xyz, vec3(0.299, 0.587, 0.114));
  alpha_1 = tmpvar_8;
  highp float tmpvar_9;
  tmpvar_9 = max ((alpha_1 - BLOOM_THRESHOLD), 0.0);
  out_SurfaceColor_2.xyz = (out_SurfaceColor_2.xyz * tmpvar_9);
  out_SurfaceColor_2.xyz = (out_SurfaceColor_2.xyz / (1.0 - BLOOM_THRESHOLD));
  _glesFragData[0] = out_SurfaceColor_2;
}

]===],
	},
}

end
