

#DEFPARAMS
#END

#DEFTAG
ShaderName = "SuperMeBloomCombine"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_BLUR1;
sampler2D TEXTURE_BLUR2;
sampler2D TEXTURE_BLUR3;
float BLOOM_PARAM;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float4 blurColor = tex2D( TEXTURE_DIFFUSE, i.uv );
    float4 color = tex2D( TEXTURE_BLUR1, i.uv );
    blurColor = color * (0.5) + blurColor;
    color = tex2D( TEXTURE_BLUR2, i.uv );
    blurColor = color * (0.25) + blurColor;
    color = tex2D( TEXTURE_BLUR3, i.uv );
    blurColor = color * (0.125) + blurColor;
    fixed4 out_SurfaceColor = blurColor;

    return out_SurfaceColor;
}
ENDCG
#END
