

#DEFPARAMS
TEXTURE_BLOOM = { "TextureBloom", TEXTURE2D, "white" },
BLOOM_PARAM = { "BloomParam", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "SuperMeBloom"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_BLOOM;
float BLOOM_PARAM;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    fixed4 out_SurfaceColor;

    float4 bloomColor = tex2D( TEXTURE_BLOOM, i.uv);
    float4 bloomI;
    bloomI.xyz = bloomColor.xyz;

    float4 mainColor = tex2D( TEXTURE_DIFFUSE, i.uv );
    mainColor = max(mainColor, float4(0.0, 0.0, 0.0, 0.0) );
    bloomI.xyz = bloomI.xyz * float3(BLOOM_PARAM,BLOOM_PARAM,BLOOM_PARAM) + mainColor.xyz;

    out_SurfaceColor.w = mainColor.w;
    out_SurfaceColor.xyz = min(bloomI.xyz, float3(1.0, 1.0, 1.0));

	return out_SurfaceColor;
}
ENDCG
#END
