//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////


#SHADER_DEFINE SupermeVertexH

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_COORDNATE0,		MEDIUM,		VEC2,			"in_Coordinate" },
		{ TEXELSIZE,  			  MEDIUM,		VEC2,			"texelSize" },
    { BLUR_RADIUS,  			MEDIUM,		VEC2,			"blurRadius" },
	}
	FUNCTION_OUTPUT =
	{
		{ AROUND_COORDNATE,		  MEDIUM,		VEC2_ARRAY,		"out_AroundCoord", "5" },
	}

#SHADER_CODE
    mediump vec2 out_AroundCoord[5];

    float radius = blurRadius.x * texelSize.x;

    out_AroundCoord[0] = in_Coordinate + vec2(-2.0*radius, 0.0);
    out_AroundCoord[1] = in_Coordinate + vec2(-1.0*radius, 0.0);
    out_AroundCoord[2] = in_Coordinate;
    out_AroundCoord[3] = in_Coordinate + vec2(1.0*radius, 0.0);
    out_AroundCoord[4] = in_Coordinate + vec2(2.0*radius, 0.0);

#END_CODE
#END_DEFINE

#SHADER_DEFINE SupermeVertexV

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_COORDNATE0,		MEDIUM,		VEC2,			"in_Coordinate" },
		{ TEXELSIZE,  			  MEDIUM,		VEC2,			"texelSize" },
    { BLUR_RADIUS,  			MEDIUM,		VEC2,			"blurRadius" },
	}
	FUNCTION_OUTPUT =
	{
		{ AROUND_COORDNATE,		  MEDIUM,		VEC2_ARRAY,		"out_AroundCoord", "5" },
	}

#SHADER_CODE
    mediump vec2 out_AroundCoord[5];

    float radius = blurRadius.y * texelSize.y;

    out_AroundCoord[0] = in_Coordinate + vec2(0.0, -2.0*radius);
    out_AroundCoord[1] = in_Coordinate + vec2(0.0, -1.0*radius);
    out_AroundCoord[2] = in_Coordinate;
    out_AroundCoord[3] = in_Coordinate + vec2(0.0, 1.0*radius);
    out_AroundCoord[4] = in_Coordinate + vec2(0.0, 2.0*radius);

#END_CODE
#END_DEFINE


#SHADER_DEFINE SupermeFragmentVH

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"in_DiffuseTexture" },
		{ AROUND_COORDNATE,		MEDIUM,	VEC2_ARRAY,		"in_AroundCoord", "5" },
	}
	FUNCTION_OUTPUT =
	{
		{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE

  vec4 color = texture2D( in_DiffuseTexture, in_AroundCoord[0] );
  lowp vec4 out_SurfaceColor =color * vec4(0.089000002, 0.089000002, 0.089000002, 0.089000002);
  color = texture2D( in_DiffuseTexture, in_AroundCoord[1] );
  out_SurfaceColor =color * vec4(0.242, 0.242, 0.242, 0.242) + out_SurfaceColor;
  color = texture2D( in_DiffuseTexture, in_AroundCoord[2] );
  out_SurfaceColor =color * vec4(0.338, 0.338, 0.338, 0.338) + out_SurfaceColor;
  color = texture2D( in_DiffuseTexture, in_AroundCoord[3] );
  out_SurfaceColor =color * vec4(0.242, 0.242, 0.242, 0.242) + out_SurfaceColor;
  color = texture2D( in_DiffuseTexture, in_AroundCoord[4] );
  out_SurfaceColor =color * vec4(0.089000002, 0.089000002, 0.089000002, 0.089000002) + out_SurfaceColor;


#END_CODE
#END_DEFINE


#SHADER_DEFINE SupermeVertex

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_COORDNATE0,		MEDIUM,		VEC2,			"in_Coordinate" },
		{ TEXELSIZE,  			  MEDIUM,		VEC2,			"texelSize" },
	}
	FUNCTION_OUTPUT =
	{
		{ AROUND_COORDNATE,		  MEDIUM,		VEC2_ARRAY,		"out_AroundCoord", "4" },
	}

#SHADER_CODE
	  mediump vec2 out_AroundCoord[4];
    vec4 d = vec4(-texelSize.x, -texelSize.y, texelSize.x, texelSize.y);

    out_AroundCoord[0] = in_Coordinate + d.xy;
    out_AroundCoord[1] = in_Coordinate + d.zy;
    out_AroundCoord[2] = in_Coordinate + d.xw;
    out_AroundCoord[3] = in_Coordinate + d.zw;

#END_CODE
#END_DEFINE

#SHADER_DEFINE SupermeFragment

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"in_DiffuseTexture" },
		{ AROUND_COORDNATE,		MEDIUM,	VEC2_ARRAY,		"in_AroundCoord", "4" },
	}
	FUNCTION_OUTPUT =
	{
		{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE

  lowp vec4 out_SurfaceColor = texture2D( in_DiffuseTexture, in_AroundCoord[0] );
  out_SurfaceColor += texture2D( in_DiffuseTexture, in_AroundCoord[1] );
  out_SurfaceColor += texture2D( in_DiffuseTexture, in_AroundCoord[2] );
  out_SurfaceColor += texture2D( in_DiffuseTexture, in_AroundCoord[3] );

  out_SurfaceColor = out_SurfaceColor * vec4(0.25);

#END_CODE
#END_DEFINE

#SHADER_DEFINE SupermeBlurTFragment

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"in_DiffuseTexture" },
    { BLOOM_THRESHOLD,		NONE,	FLOAT,		"bloomThreshold" },
		{ AROUND_COORDNATE,		MEDIUM,	VEC2_ARRAY,		"in_AroundCoord", "4" },
	}
	FUNCTION_OUTPUT =
	{
		{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE

  lowp vec4 out_SurfaceColor = texture2D( in_DiffuseTexture, in_AroundCoord[0] );
  out_SurfaceColor += texture2D( in_DiffuseTexture, in_AroundCoord[1] );
  out_SurfaceColor += texture2D( in_DiffuseTexture, in_AroundCoord[2] );
  out_SurfaceColor += texture2D( in_DiffuseTexture, in_AroundCoord[3] );

  out_SurfaceColor = out_SurfaceColor * vec4(0.25);

  float alpha = dot(out_SurfaceColor.xyz, vec3(0.29899999, 0.58700001, 0.114));
 // out_SurfaceColor.w = max(alpha - bloomThreshold, 0.0);
  out_SurfaceColor.xyz *= max(alpha - bloomThreshold, 0.0);
  
  out_SurfaceColor.xyz /= (1.0 - bloomThreshold);
//  out_SurfaceColor.xyz *= 8.0;

#END_CODE
#END_DEFINE
