function DefineParams()
	Properties = 
	{
		
FRAME_SIZE                   = {"FRAME_SIZE", VEC2, "16.0, 16.0"},
BLOCK_SIZE                   = {"BLOCK_SIZE", VEC2, "16.0, 16.0"},
HISTOGRAM_SIZE               = {"HISTOGRAM_SIZE", VEC2, "16.0, 16.0"},
GAMMA_RGB                    = {"GAMMA_RGB",  VEC3, "1.0, 1.0, 1.0"},
ALPHA_HIGH_RGB               = {"ALPHA_HIGH_RGB",  VEC3, "1.0, 1.0, 1.0"},
ALPHA_HIGH_DIFF_GAIN_RGB     = {"ALPHA_HIGH_DIFF_GAIN_RGB", VEC3, "1.0, 1.0, 1.0"},
ALPHA_HIGH_DIFF_GAIN_RGB_MIN = {"ALPHA_HIGH_DIFF_GAIN_RGB_MIN", VEC3, "1.0, 1.0, 1.0"},
ALPHA_HIGH_DIFF_GAIN_RGB_MAX = {"ALPHA_HIGH_DIFF_GAIN_RGB_MAX", VEC3, "1.0, 1.0, 1.0"},
ALPHA_LOW_RGB                = {"ALPHA_LOW_RGB",  VEC3, "1.0, 1.0, 1.0"},
ALPHA_LOW_DIFF_GAIN_RGB      = {"ALPHA_LOW_DIFF_GAIN_RGB", VEC3, "1.0, 1.0, 1.0"},
ALPHA_LOW_DIFF_GAIN_RGB_MIN  = {"ALPHA_LOW_DIFF_GAIN_RGB_MIN", VEC3, "1.0, 1.0, 1.0"},
ALPHA_LOW_DIFF_GAIN_RGB_MAX  = {"ALPHA_LOW_DIFF_GAIN_RGB_MAX", VEC3, "1.0, 1.0, 1.0"},
G0_GAIN_RGB                  = {"G0_GAIN_RGB", VEC3, "1.0, 1.0, 1.0"},
SIGMA_RGB                    = {"SIGMA_RGB", VEC3, "1.0, 1.0, 1.0"},
BETA_RGB                     = {"BETA_RGB", VEC3, "1.0, 1.0, 1.0"},
HISTOGRAM                    = {"HISTOGRAM", TEXTURE2D, "HISTOGRAM"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "LutGenStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "HISTOGRAM_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "GAMMA_RGB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ALPHA_HIGH_RGB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ALPHA_HIGH_DIFF_GAIN_RGB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ALPHA_HIGH_DIFF_GAIN_RGB_MIN",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ALPHA_HIGH_DIFF_GAIN_RGB_MAX",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ALPHA_LOW_RGB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ALPHA_LOW_DIFF_GAIN_RGB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ALPHA_LOW_DIFF_GAIN_RGB_MIN",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ALPHA_LOW_DIFF_GAIN_RGB_MAX",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "G0_GAIN_RGB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIGMA_RGB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BETA_RGB",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTOGRAM",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec2 HISTOGRAM_SIZE;
uniform highp vec3 GAMMA_RGB;
uniform highp vec3 ALPHA_HIGH_RGB;
uniform highp vec3 ALPHA_HIGH_DIFF_GAIN_RGB;
uniform highp vec3 ALPHA_HIGH_DIFF_GAIN_RGB_MIN;
uniform highp vec3 ALPHA_HIGH_DIFF_GAIN_RGB_MAX;
uniform highp vec3 ALPHA_LOW_RGB;
uniform highp vec3 ALPHA_LOW_DIFF_GAIN_RGB;
uniform highp vec3 ALPHA_LOW_DIFF_GAIN_RGB_MIN;
uniform highp vec3 ALPHA_LOW_DIFF_GAIN_RGB_MAX;
uniform highp vec3 G0_GAIN_RGB;
uniform highp vec3 SIGMA_RGB;
uniform highp vec3 BETA_RGB;
uniform sampler2D HISTOGRAM;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 g0_offset_1;
  highp vec3 xlat_varsign_2;
  highp vec4 lut_rgb_3;
  highp float normalized_accu_count_5;
  highp vec2 histogram_size_inv_6;
  highp float hist_mean_float_7;
  highp int hist_median_8;
  highp int hist_start_y_9;
  highp int hist_start_x_10;
  highp float tmpvar_11;
  tmpvar_11 = (xlv_TEXCOORD0.x * HISTOGRAM_SIZE.x);
  highp float tmpvar_12;
  tmpvar_12 = (xlv_TEXCOORD0.y * HISTOGRAM_SIZE.y);
  highp int tmpvar_13;
  tmpvar_13 = (int((tmpvar_11 / 16.0)) * 16);
  hist_start_x_10 = tmpvar_13;
  highp int tmpvar_14;
  tmpvar_14 = (int((tmpvar_12 / 16.0)) * 16);
  hist_start_y_9 = tmpvar_14;
  hist_median_8 = 0;
  hist_mean_float_7 = 0.0;
  histogram_size_inv_6 = (1.0/(HISTOGRAM_SIZE));
  normalized_accu_count_5 = 0.0;
  for (highp int hist_idx_y_4 = 0; hist_idx_y_4 < 16; hist_idx_y_4++) {
    for (highp int hist_idx_x_15 = 0; hist_idx_x_15 < 16; hist_idx_x_15++) {
      highp float normalized_entry_num_16;
      highp int tmpvar_17;
      tmpvar_17 = ((hist_idx_y_4 * 16) + hist_idx_x_15);
      highp vec2 tmpvar_18;
      tmpvar_18.x = (float((hist_idx_x_15 + hist_start_x_10)) * histogram_size_inv_6.x);
      tmpvar_18.y = (float((hist_idx_y_4 + hist_start_y_9)) * histogram_size_inv_6.y);
      lowp float tmpvar_19;
      tmpvar_19 = texture (HISTOGRAM, tmpvar_18).x;
      normalized_entry_num_16 = tmpvar_19;
      hist_mean_float_7 = (hist_mean_float_7 + (normalized_entry_num_16 * float(tmpvar_17)));
      normalized_accu_count_5 = (normalized_accu_count_5 + normalized_entry_num_16);
      highp int tmpvar_20;
      if ((normalized_accu_count_5 > 0.5)) {
        tmpvar_20 = hist_median_8;
      } else {
        tmpvar_20 = tmpvar_17;
      };
      hist_median_8 = tmpvar_20;
    };
  };
  highp int tmpvar_21;
  tmpvar_21 = int(hist_mean_float_7);
  highp int tmpvar_22;
  tmpvar_22 = int(abs(float(
    (hist_median_8 - tmpvar_21)
  )));
  highp float tmpvar_23;
  tmpvar_23 = (ALPHA_HIGH_RGB.x * clamp ((
    float(tmpvar_22)
   * ALPHA_HIGH_DIFF_GAIN_RGB.x), ALPHA_HIGH_DIFF_GAIN_RGB_MIN.x, ALPHA_HIGH_DIFF_GAIN_RGB_MAX.x));
  highp float tmpvar_24;
  tmpvar_24 = (ALPHA_HIGH_RGB.y * clamp ((
    float(tmpvar_22)
   * ALPHA_HIGH_DIFF_GAIN_RGB.y), ALPHA_HIGH_DIFF_GAIN_RGB_MIN.y, ALPHA_HIGH_DIFF_GAIN_RGB_MAX.y));
  highp float tmpvar_25;
  tmpvar_25 = (ALPHA_HIGH_RGB.z * clamp ((
    float(tmpvar_22)
   * ALPHA_HIGH_DIFF_GAIN_RGB.z), ALPHA_HIGH_DIFF_GAIN_RGB_MIN.z, ALPHA_HIGH_DIFF_GAIN_RGB_MAX.z));
  highp float tmpvar_26;
  tmpvar_26 = (ALPHA_LOW_RGB.x * clamp ((
    float(tmpvar_22)
   * ALPHA_LOW_DIFF_GAIN_RGB.x), ALPHA_LOW_DIFF_GAIN_RGB_MIN.x, ALPHA_LOW_DIFF_GAIN_RGB_MAX.x));
  highp float tmpvar_27;
  tmpvar_27 = (ALPHA_LOW_RGB.y * clamp ((
    float(tmpvar_22)
   * ALPHA_LOW_DIFF_GAIN_RGB.y), ALPHA_LOW_DIFF_GAIN_RGB_MIN.y, ALPHA_LOW_DIFF_GAIN_RGB_MAX.y));
  highp float tmpvar_28;
  tmpvar_28 = (ALPHA_LOW_RGB.z * clamp ((
    float(tmpvar_22)
   * ALPHA_LOW_DIFF_GAIN_RGB.z), ALPHA_LOW_DIFF_GAIN_RGB_MIN.z, ALPHA_LOW_DIFF_GAIN_RGB_MAX.z));
  highp int tmpvar_29;
  tmpvar_29 = ((int(
    (tmpvar_12 - float(tmpvar_14))
  ) * 16) + int((tmpvar_11 - 
    float(tmpvar_13)
  )));
  lut_rgb_3.w = 1.0;
  highp vec3 tmpvar_30;
  tmpvar_30.x = float(tmpvar_29);
  tmpvar_30.y = float(tmpvar_29);
  tmpvar_30.z = float(tmpvar_29);
  lut_rgb_3.xyz = clamp ((vec3(255.0, 255.0, 255.0) - (
    pow (((vec3(255.0, 255.0, 255.0) - tmpvar_30) / vec3(255.0, 255.0, 255.0)), GAMMA_RGB)
   * vec3(255.0, 255.0, 255.0))), vec3(0.0, 0.0, 0.0), vec3(255.0, 255.0, 255.0));
  highp vec3 tmpvar_31;
  tmpvar_31 = ((float(
    (tmpvar_21 + hist_median_8)
  ) * 0.5) * G0_GAIN_RGB);
  highp vec3 tmpvar_32;
  tmpvar_32 = (lut_rgb_3.xyz - tmpvar_31);
  highp vec3 tmpvar_33;
  tmpvar_33 = abs(tmpvar_32);
  xlat_varsign_2 = vec3(0.0, 0.0, 0.0);
  highp float tmpvar_34;
  if ((tmpvar_32.x >= 0.0)) {
    tmpvar_34 = 1.0;
  } else {
    tmpvar_34 = -1.0;
  };
  xlat_varsign_2.x = tmpvar_34;
  highp float tmpvar_35;
  if ((tmpvar_32.y >= 0.0)) {
    tmpvar_35 = 1.0;
  } else {
    tmpvar_35 = -1.0;
  };
  xlat_varsign_2.y = tmpvar_35;
  highp float tmpvar_36;
  if ((tmpvar_32.z >= 0.0)) {
    tmpvar_36 = 1.0;
  } else {
    tmpvar_36 = -1.0;
  };
  xlat_varsign_2.z = tmpvar_36;
  highp float tmpvar_37;
  if ((tmpvar_34 > 0.0)) {
    tmpvar_37 = tmpvar_23;
  } else {
    tmpvar_37 = tmpvar_26;
  };
  highp float tmpvar_38;
  if ((tmpvar_35 > 0.0)) {
    tmpvar_38 = tmpvar_24;
  } else {
    tmpvar_38 = tmpvar_27;
  };
  highp float tmpvar_39;
  if ((tmpvar_36 > 0.0)) {
    tmpvar_39 = tmpvar_25;
  } else {
    tmpvar_39 = tmpvar_28;
  };
  g0_offset_1 = vec3(0.0, 0.0, 0.0);
  highp float tmpvar_40;
  if ((tmpvar_33.x > SIGMA_RGB.x)) {
    tmpvar_40 = (((tmpvar_33.x - SIGMA_RGB.x) * BETA_RGB.x) + SIGMA_RGB.x);
  } else {
    tmpvar_40 = (pow ((tmpvar_33.x / SIGMA_RGB.x), tmpvar_37) * SIGMA_RGB.x);
  };
  g0_offset_1.x = tmpvar_40;
  highp float tmpvar_41;
  if ((tmpvar_33.y > SIGMA_RGB.y)) {
    tmpvar_41 = (((tmpvar_33.y - SIGMA_RGB.y) * BETA_RGB.y) + SIGMA_RGB.y);
  } else {
    tmpvar_41 = (pow ((tmpvar_33.y / SIGMA_RGB.y), tmpvar_38) * SIGMA_RGB.y);
  };
  g0_offset_1.y = tmpvar_41;
  highp float tmpvar_42;
  if ((tmpvar_33.z > SIGMA_RGB.z)) {
    tmpvar_42 = (((tmpvar_33.z - SIGMA_RGB.z) * BETA_RGB.z) + SIGMA_RGB.z);
  } else {
    tmpvar_42 = (pow ((tmpvar_33.z / SIGMA_RGB.z), tmpvar_39) * SIGMA_RGB.z);
  };
  g0_offset_1.z = tmpvar_42;
  lut_rgb_3.xyz = clamp ((tmpvar_31 + (xlat_varsign_2 * g0_offset_1)), vec3(0.0, 0.0, 0.0), vec3(255.0, 255.0, 255.0));
  lut_rgb_3.xyz = (lut_rgb_3.xyz / vec3(255.0, 255.0, 255.0));
  _glesFragData[0] = lut_rgb_3;
}

]===],
	},
}

end