function DefineParams()
	Properties = 
	{
		
FRAME_SIZE      = {"FRAME_SIZE", VEC2, "16.0, 16.0"},
BLOCK_SIZE      = {"BLOCK_SIZE", VEC2, "16.0, 16.0"},
HISTOGRAM_SIZE  = {"HISTOGRAM_SIZE", VEC2, "16.0, 16.0"},
SATURATION_GAIN = {"SATURATION_GAIN", FLOAT, "1.0"},
SPLIT_DIRECTION = {"SPLIT_DIRECTION", FLOAT, "0.0"},
SPLIT_RATIO     = {"SPLIT_RATIO", FLOAT, "0.0"},
CUR_FRAME       = {"CUR_FRAME", TEXTURE2D, "CUR_FRAME"},
RGB_LUT         = {"RGB_LUT", TEXTURE2D, "RGB_LUT"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "LutApplyStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "FRAME_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BLOCK_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTOGRAM_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SATURATION_GAIN",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SPLIT_DIRECTION",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SPLIT_RATIO",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CUR_FRAME",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RGB_LUT",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec2 FRAME_SIZE;
uniform highp vec2 BLOCK_SIZE;
uniform highp vec2 HISTOGRAM_SIZE;
uniform highp float SATURATION_GAIN;
uniform highp float SPLIT_DIRECTION;
uniform highp float SPLIT_RATIO;
uniform sampler2D CUR_FRAME;
uniform sampler2D RGB_LUT;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp float val_3_1;
  highp float val_2_2;
  highp float val_1_3;
  highp float val_0_4;
  highp float down_coord_y_5;
  highp float right_coord_x_6;
  highp float up_coord_y_7;
  highp float left_coord_x_8;
  highp vec4 out_rgba_9;
  highp vec3 in_rgb_10;
  highp int tmpvar_11;
  tmpvar_11 = int(ceil((FRAME_SIZE.x / BLOCK_SIZE.x)));
  highp int tmpvar_12;
  tmpvar_12 = int(ceil((FRAME_SIZE.y / BLOCK_SIZE.y)));
  highp float tmpvar_13;
  tmpvar_13 = (xlv_TEXCOORD0.x * FRAME_SIZE.x);
  highp float tmpvar_14;
  tmpvar_14 = (xlv_TEXCOORD0.y * FRAME_SIZE.y);
  highp int tmpvar_15;
  tmpvar_15 = int((tmpvar_13 / BLOCK_SIZE.x));
  highp int tmpvar_16;
  tmpvar_16 = int((tmpvar_14 / BLOCK_SIZE.y));
  highp int tmpvar_17;
  if (((tmpvar_15 + 1) >= tmpvar_11)) {
    tmpvar_17 = (tmpvar_11 - 1);
  } else {
    tmpvar_17 = (tmpvar_15 + 1);
  };
  highp int tmpvar_18;
  if (((tmpvar_16 + 1) >= tmpvar_12)) {
    tmpvar_18 = (tmpvar_12 - 1);
  } else {
    tmpvar_18 = (tmpvar_16 + 1);
  };
  highp float tmpvar_19;
  tmpvar_19 = ((tmpvar_13 - (
    float(tmpvar_15)
   * BLOCK_SIZE.x)) / BLOCK_SIZE.x);
  highp float tmpvar_20;
  tmpvar_20 = ((tmpvar_14 - (
    float(tmpvar_16)
   * BLOCK_SIZE.y)) / BLOCK_SIZE.y);
  lowp vec3 tmpvar_21;
  tmpvar_21 = texture (CUR_FRAME, xlv_TEXCOORD0).xyz;
  in_rgb_10 = tmpvar_21;
  highp int tmpvar_22;
  tmpvar_22 = int(((in_rgb_10.x * 255.0) + 0.5));
  highp int tmpvar_23;
  tmpvar_23 = int(((in_rgb_10.y * 255.0) + 0.5));
  highp int tmpvar_24;
  tmpvar_24 = int(((in_rgb_10.z * 255.0) + 0.5));
  highp int tmpvar_25;
  tmpvar_25 = (tmpvar_22 / 16);
  highp int tmpvar_26;
  tmpvar_26 = (tmpvar_22 - (tmpvar_25 * 16));
  highp int tmpvar_27;
  tmpvar_27 = (tmpvar_23 / 16);
  highp int tmpvar_28;
  tmpvar_28 = (tmpvar_23 - (tmpvar_27 * 16));
  highp int tmpvar_29;
  tmpvar_29 = (tmpvar_24 / 16);
  highp int tmpvar_30;
  tmpvar_30 = (tmpvar_24 - (tmpvar_29 * 16));
  out_rgba_9.w = 1.0;
  highp float tmpvar_31;
  tmpvar_31 = ((float(
    ((tmpvar_15 * 16) + tmpvar_26)
  ) + 0.5) / HISTOGRAM_SIZE.x);
  highp float tmpvar_32;
  tmpvar_32 = ((float(
    ((tmpvar_16 * 16) + tmpvar_25)
  ) + 0.5) / HISTOGRAM_SIZE.y);
  highp float tmpvar_33;
  tmpvar_33 = ((float(
    ((tmpvar_17 * 16) + tmpvar_26)
  ) + 0.5) / HISTOGRAM_SIZE.x);
  highp float tmpvar_34;
  tmpvar_34 = ((float(
    ((tmpvar_18 * 16) + tmpvar_25)
  ) + 0.5) / HISTOGRAM_SIZE.y);
  highp vec2 tmpvar_35;
  tmpvar_35.x = tmpvar_31;
  tmpvar_35.y = tmpvar_32;
  lowp float tmpvar_36;
  tmpvar_36 = texture (RGB_LUT, tmpvar_35).x;
  val_0_4 = tmpvar_36;
  highp vec2 tmpvar_37;
  tmpvar_37.x = tmpvar_33;
  tmpvar_37.y = tmpvar_32;
  lowp float tmpvar_38;
  tmpvar_38 = texture (RGB_LUT, tmpvar_37).x;
  val_1_3 = tmpvar_38;
  highp vec2 tmpvar_39;
  tmpvar_39.x = tmpvar_31;
  tmpvar_39.y = tmpvar_34;
  lowp float tmpvar_40;
  tmpvar_40 = texture (RGB_LUT, tmpvar_39).x;
  val_2_2 = tmpvar_40;
  highp vec2 tmpvar_41;
  tmpvar_41.x = tmpvar_33;
  tmpvar_41.y = tmpvar_34;
  lowp float tmpvar_42;
  tmpvar_42 = texture (RGB_LUT, tmpvar_41).x;
  val_3_1 = tmpvar_42;
  out_rgba_9.x = mix (mix (val_0_4, val_1_3, tmpvar_19), mix (val_2_2, val_3_1, tmpvar_19), tmpvar_20);
  left_coord_x_8 = ((float(
    ((tmpvar_15 * 16) + tmpvar_28)
  ) + 0.5) / HISTOGRAM_SIZE.x);
  up_coord_y_7 = ((float(
    ((tmpvar_16 * 16) + tmpvar_27)
  ) + 0.5) / HISTOGRAM_SIZE.y);
  right_coord_x_6 = ((float(
    ((tmpvar_17 * 16) + tmpvar_28)
  ) + 0.5) / HISTOGRAM_SIZE.x);
  down_coord_y_5 = ((float(
    ((tmpvar_18 * 16) + tmpvar_27)
  ) + 0.5) / HISTOGRAM_SIZE.y);
  highp vec2 tmpvar_43;
  tmpvar_43.x = left_coord_x_8;
  tmpvar_43.y = up_coord_y_7;
  lowp vec4 tmpvar_44;
  tmpvar_44 = texture (RGB_LUT, tmpvar_43);
  val_0_4 = tmpvar_44.y;
  highp vec2 tmpvar_45;
  tmpvar_45.x = right_coord_x_6;
  tmpvar_45.y = up_coord_y_7;
  lowp vec4 tmpvar_46;
  tmpvar_46 = texture (RGB_LUT, tmpvar_45);
  val_1_3 = tmpvar_46.y;
  highp vec2 tmpvar_47;
  tmpvar_47.x = left_coord_x_8;
  tmpvar_47.y = down_coord_y_5;
  lowp vec4 tmpvar_48;
  tmpvar_48 = texture (RGB_LUT, tmpvar_47);
  val_2_2 = tmpvar_48.y;
  highp vec2 tmpvar_49;
  tmpvar_49.x = right_coord_x_6;
  tmpvar_49.y = down_coord_y_5;
  lowp vec4 tmpvar_50;
  tmpvar_50 = texture (RGB_LUT, tmpvar_49);
  val_3_1 = tmpvar_50.y;
  out_rgba_9.y = mix (mix (val_0_4, val_1_3, tmpvar_19), mix (val_2_2, val_3_1, tmpvar_19), tmpvar_20);
  left_coord_x_8 = ((float(
    ((tmpvar_15 * 16) + tmpvar_30)
  ) + 0.5) / HISTOGRAM_SIZE.x);
  up_coord_y_7 = ((float(
    ((tmpvar_16 * 16) + tmpvar_29)
  ) + 0.5) / HISTOGRAM_SIZE.y);
  right_coord_x_6 = ((float(
    ((tmpvar_17 * 16) + tmpvar_30)
  ) + 0.5) / HISTOGRAM_SIZE.x);
  down_coord_y_5 = ((float(
    ((tmpvar_18 * 16) + tmpvar_29)
  ) + 0.5) / HISTOGRAM_SIZE.y);
  highp vec2 tmpvar_51;
  tmpvar_51.x = left_coord_x_8;
  tmpvar_51.y = up_coord_y_7;
  lowp vec4 tmpvar_52;
  tmpvar_52 = texture (RGB_LUT, tmpvar_51);
  val_0_4 = tmpvar_52.z;
  highp vec2 tmpvar_53;
  tmpvar_53.x = right_coord_x_6;
  tmpvar_53.y = up_coord_y_7;
  lowp vec4 tmpvar_54;
  tmpvar_54 = texture (RGB_LUT, tmpvar_53);
  val_1_3 = tmpvar_54.z;
  highp vec2 tmpvar_55;
  tmpvar_55.x = left_coord_x_8;
  tmpvar_55.y = down_coord_y_5;
  lowp vec4 tmpvar_56;
  tmpvar_56 = texture (RGB_LUT, tmpvar_55);
  val_2_2 = tmpvar_56.z;
  highp vec2 tmpvar_57;
  tmpvar_57.x = right_coord_x_6;
  tmpvar_57.y = down_coord_y_5;
  lowp vec4 tmpvar_58;
  tmpvar_58 = texture (RGB_LUT, tmpvar_57);
  val_3_1 = tmpvar_58.z;
  out_rgba_9.z = mix (mix (val_0_4, val_1_3, tmpvar_19), mix (val_2_2, val_3_1, tmpvar_19), tmpvar_20);
  out_rgba_9.xyz = clamp ((out_rgba_9.xyz + (vec3(SATURATION_GAIN) * 
    (out_rgba_9.xyz - vec3((((0.299 * out_rgba_9.x) + (0.587 * out_rgba_9.y)) + (0.114 * out_rgba_9.z))))
  )), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  highp float tmpvar_59;
  tmpvar_59 = floor((SPLIT_DIRECTION + 0.5));
  highp float tmpvar_60;
  if ((tmpvar_59 == 0.0)) {
    tmpvar_60 = xlv_TEXCOORD0.x;
  } else {
    tmpvar_60 = xlv_TEXCOORD0.y;
  };
  highp vec3 tmpvar_61;
  if ((tmpvar_60 > SPLIT_RATIO)) {
    tmpvar_61 = in_rgb_10;
  } else {
    tmpvar_61 = out_rgba_9.xyz;
  };
  out_rgba_9.xyz = tmpvar_61;
  _glesFragData[0] = out_rgba_9;
}

]===],
	},
}

end