function DefineParams()
	Properties = 
	{
		
FRAME_SIZE     = {"FRAME_SIZE", VEC2, "16.0, 16.0"},
BLOCK_SIZE     = {"BLOCK_SIZE", VEC2, "16.0, 16.0"},
HISTOGRAM_SIZE = {"HISTOGRAM_SIZE", VEC2, "16.0, 16.0"},
CUR_FRAME      = {"CUR_FRAME", TEXTURE2D, "CUR_FRAME"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "HistogramGenStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CUR_FRAME",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FRAME_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BLOCK_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTOGRAM_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#extension GL_EXT_shader_texture_lod : enable
lowp vec4 impl_low_texture2DLodEXT(lowp sampler2D sampler, highp vec2 coord, mediump float lod)
{
#if defined(GL_EXT_shader_texture_lod)
	return texture2DLodEXT(sampler, coord, lod);
#else
	return texture2D(sampler, coord, lod);
#endif
}

uniform sampler2D CUR_FRAME;
uniform highp vec2 FRAME_SIZE;
uniform highp vec2 BLOCK_SIZE;
uniform highp vec2 HISTOGRAM_SIZE;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 hist_entry_val_2;
  highp vec2 in_tex_size_inv_3;
  highp int in_frag_idx_end_y_4;
  highp int in_frag_idx_end_x_5;
  highp int in_frag_idx_start_y_6;
  highp int hist_entry_7;
  highp float tmpvar_8;
  tmpvar_8 = (xlv_TEXCOORD0.x * HISTOGRAM_SIZE.x);
  highp float tmpvar_9;
  tmpvar_9 = (xlv_TEXCOORD0.y * HISTOGRAM_SIZE.y);
  highp int tmpvar_10;
  tmpvar_10 = int((tmpvar_8 / 16.0));
  highp int tmpvar_11;
  tmpvar_11 = int((tmpvar_9 / 16.0));
  hist_entry_7 = ((int(
    (tmpvar_9 - float((tmpvar_11 * 16)))
  ) * 16) + int((tmpvar_8 - 
    float((tmpvar_10 * 16))
  )));
  highp int tmpvar_12;
  tmpvar_12 = int((float(tmpvar_10) * BLOCK_SIZE.x));
  highp int tmpvar_13;
  tmpvar_13 = int((float(tmpvar_11) * BLOCK_SIZE.y));
  in_frag_idx_start_y_6 = tmpvar_13;
  in_frag_idx_end_x_5 = int((float(tmpvar_12) + BLOCK_SIZE.x));
  in_frag_idx_end_y_4 = int((float(tmpvar_13) + BLOCK_SIZE.y));
  in_tex_size_inv_3 = (1.0/(FRAME_SIZE));
  hist_entry_val_2 = vec4(0.0, 0.0, 0.0, 1.0);
  for (highp int idx_x_1 = tmpvar_12; idx_x_1 < in_frag_idx_end_x_5; idx_x_1++) {
    for (highp int idx_y_14 = in_frag_idx_start_y_6; idx_y_14 < in_frag_idx_end_y_4; idx_y_14++) {
      highp vec2 in_tex_coord_15;
      highp vec2 tmpvar_16;
      tmpvar_16.x = (float(idx_x_1) * in_tex_size_inv_3.x);
      tmpvar_16.y = (float(idx_y_14) * in_tex_size_inv_3.y);
      in_tex_coord_15 = clamp (tmpvar_16, vec2(0.0, 0.0), vec2(1.0, 1.0));
      lowp vec4 tmpvar_17;
      tmpvar_17 = impl_low_texture2DLodEXT (CUR_FRAME, in_tex_coord_15, 0.0);
      highp vec4 tmpvar_18;
      tmpvar_18 = tmpvar_17;
      highp int tmpvar_19;
      tmpvar_19 = int(((
        (((0.299 * tmpvar_18.x) + (0.587 * tmpvar_18.y)) + (0.114 * tmpvar_18.z))
       * 255.0) + 0.5));
      highp float tmpvar_20;
      if ((tmpvar_19 == hist_entry_7)) {
        tmpvar_20 = 1.0;
      } else {
        tmpvar_20 = 0.0;
      };
      hist_entry_val_2.x = (hist_entry_val_2.x + tmpvar_20);
    };
  };
  hist_entry_val_2.x = (hist_entry_val_2.x * (1.0/((BLOCK_SIZE.x * BLOCK_SIZE.y))));
  gl_FragData[0] = hist_entry_val_2;
}

]===],
	},
}

end