
function DefineParams()
	Properties = 
	{
		
SHINE_TEXTURE = { "Shine Tex", TEXTURE2D, "0.0,0.0" },
BLUR_RADIUS = { "Radius", FLOAT, "0.0" },
UNIFORM_OFFSET = { "Offset", VEC2, "0.0,0.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "ShineLightBlur"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "SHINE_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BLUR_RADIUS",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_OFFSET",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D SHINE_TEXTURE;
uniform highp float BLUR_RADIUS;
uniform highp vec2 UNIFORM_OFFSET;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp int i_1_1;
  highp vec4 sum_2;
  highp int total_3;
  highp vec2 cur_pos_4;
  highp int tmpvar_5;
  tmpvar_5 = int(BLUR_RADIUS);
  cur_pos_4 = (xlv_TEXCOORD0 - (UNIFORM_OFFSET * float(tmpvar_5)));
  highp int tmpvar_6;
  tmpvar_6 = ((tmpvar_5 * 2) + 1);
  total_3 = tmpvar_6;
  sum_2 = vec4(0.0, 0.0, 0.0, 0.0);
  i_1_1 = 0;
  for (; i_1_1 < total_3; i_1_1++, cur_pos_4 = (cur_pos_4 + UNIFORM_OFFSET)) {
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture2D (SHINE_TEXTURE, cur_pos_4);
    sum_2 = (sum_2 + tmpvar_7);
  };
  sum_2 = (sum_2 / float(tmpvar_6));
  gl_FragData[0] = sum_2;
}

]===],
	},
}

end
