
function DefineParams()
	Properties = 
	{
		
RGB_TEXTURE = { "main Color", TEXTURE2D, "0.0,0.0" },
THRESHOLD = {"Threshold", FLOAT, "0.0"},

POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},

	}
	Attributes = 
	{
		POST_EFFECT_ALPHA = "Keywords(POST_EFFECT_ALPHA_ON,POST_EFFECT_ALPHA_OFF)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "ShineLight"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"POST_EFFECT_ALPHA_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "RGB_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "THRESHOLD",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D RGB_TEXTURE;
uniform highp float THRESHOLD;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 rgba_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = (texture (RGB_TEXTURE, xlv_TEXCOORD0) + 0.001960784);
  rgba_1 = tmpvar_2;
  highp float tmpvar_3;
  tmpvar_3 = dot (vec3(0.299, 0.587, 0.114), rgba_1.xyz);
  highp vec3 tmpvar_4;
  if ((tmpvar_3 > THRESHOLD)) {
    tmpvar_4 = rgba_1.xyz;
  } else {
    tmpvar_4 = vec3(0.0, 0.0, 0.0);
  };
  highp vec4 tmpvar_5;
  tmpvar_5.xyz = tmpvar_4;
  tmpvar_5.w = rgba_1.w;
  _glesFragData[0] = tmpvar_5;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"POST_EFFECT_ALPHA_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "RGB_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "THRESHOLD",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D RGB_TEXTURE;
uniform highp float THRESHOLD;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 rgb_1;
  lowp vec3 tmpvar_2;
  tmpvar_2 = (texture (RGB_TEXTURE, xlv_TEXCOORD0).xyz + 0.001960784);
  rgb_1 = tmpvar_2;
  highp float tmpvar_3;
  tmpvar_3 = dot (vec3(0.299, 0.587, 0.114), rgb_1);
  highp vec3 tmpvar_4;
  if ((tmpvar_3 > THRESHOLD)) {
    tmpvar_4 = rgb_1;
  } else {
    tmpvar_4 = vec3(0.0, 0.0, 0.0);
  };
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_4;
  _glesFragData[0] = tmpvar_5;
}

]===],
	},
}

end