

#DEFPARAMS
_FrameTex = {"FrameTexture", TEXTURE2D, "white" },
_GreyTex = {"GreyTexture", TEXTURE2D, "white" },
_VerticalOffset = {"VerticalOffset", FLOAT, "0.0"},
_HorizontalOffset = {"HorizontalOffset", FLOAT, "1.0"},
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "FrameDisp"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv     : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _FrameTex;
sampler2D _GreyTex;
float _VerticalOffset;
float _HorizontalOffset;



v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{	
    fixed3 greyColor  = tex2D(_GreyTex, i.uv).rgb;
    fixed lum = 0.2125 * greyColor.r + 0.7154 * greyColor.g + 0.0721 * greyColor.b;

    float2 offset = float2(_HorizontalOffset, _VerticalOffset);
    offset *= lum;

    fixed4 frameColor = tex2D(_FrameTex, i.uv + offset);
    frameColor.rgb *= frameColor.a;
	#ifdef POST_EFFECT_ALPHA_OFF
		frameColor.a = 1.0;
	#elif POST_EFFECT_ALPHA_ON
	#endif
    return frameColor;
}
ENDCG
#END
