#DEFPARAMS
CURL        = {"CURL", TEXTURE2D, "CURL"},
VELOCITY    = {"VELOCITY", TEXTURE2D, "VELOCITY"},
TEXEL_SIZE  = {"TEXEL_SIZE", VEC2, "64.0, 64.0"},
CURL_CONFIG = {"CURL_CONFIG", FLOAT, "30.0"},
TIME_STEP   = {"TIME_STEP", FLOAT, "0.01"},
FLOAT_MIN   = {"FLOAT_MIN", FLOAT, "-100.0"},
FLOAT_MAX   = {"FLOAT_MAX", FLOAT, "100.0"},
#END

#DEFTAG
ShaderName  = "VorticityStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 center_uv: TEXCOORD0;
    float2 left_uv:   TEXCOORD1;
    float2 right_uv:  TEXCOORD2;
    float2 top_uv:    TEXCOORD3;
    float2 bottom_uv: TEXCOORD4;

    float4 vertex : SV_POSITION;
};

sampler2D CURL;
sampler2D VELOCITY;
float2    TEXEL_SIZE;
float     CURL_CONFIG;
float     TIME_STEP;
float     FLOAT_MIN;
float     FLOAT_MAX;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);

    o.center_uv = v.uv.xy;
    o.left_uv   = o.center_uv - float2(TEXEL_SIZE.x, 0.0);
    o.right_uv  = o.center_uv + float2(TEXEL_SIZE.x, 0.0);
    o.top_uv    = o.center_uv + float2(0.0, TEXEL_SIZE.y);
    o.bottom_uv = o.center_uv - float2(0.0, TEXEL_SIZE.y);

    return o;
}

float4 frag(v2f i) : SV_Target
{
    float range  = FLOAT_MAX - FLOAT_MIN;
    float center = tex2D(CURL, i.center_uv).x * range + FLOAT_MIN;
    float left   = tex2D(CURL, i.left_uv).x * range + FLOAT_MIN;
    float right  = tex2D(CURL, i.right_uv).x * range + FLOAT_MIN;
    float top    = tex2D(CURL, i.top_uv).x * range + FLOAT_MIN;
    float bottom = tex2D(CURL, i.bottom_uv).x * range + FLOAT_MIN;

    float2 force = 0.5 * float2(abs(top) - abs(bottom), abs(right) - abs(left));
    force       /= (length(force) + 0.0001);
    force       *= CURL_CONFIG * center;
    force.y     *= -1.0;

    float2 vel = tex2D(VELOCITY, i.center_uv).xy * range + FLOAT_MIN;
    vel        = vel + force * TIME_STEP;
    vel        = (vel - float2(FLOAT_MIN, FLOAT_MIN)) / range;
    return float4(vel, 0.0, 1.0);
}
ENDCG
#END