function DefineParams()
	Properties = 
	{
		
PRESSURE   = {"PRESSURE", TEXTURE2D, "PRESSURE"},
VELOCITY   = {"VELOCITY", TEXTURE2D, "VELOCITY"},
TEXEL_SIZE = {"TEXEL_SIZE", VEC2, "64.0, 64.0"},
FLOAT_MIN  = {"FLOAT_MIN", FLOAT, "-100.0"},
FLOAT_MAX  = {"FLOAT_MAX", FLOAT, "100.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "PressureForceStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXEL_SIZE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "PRESSURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "VELOCITY",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FLOAT_MIN",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FLOAT_MAX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 TEXEL_SIZE;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_2;
  tmpvar_2.y = 0.0;
  tmpvar_2.x = TEXEL_SIZE.x;
  highp vec2 tmpvar_3;
  tmpvar_3.y = 0.0;
  tmpvar_3.x = TEXEL_SIZE.x;
  highp vec2 tmpvar_4;
  tmpvar_4.x = 0.0;
  tmpvar_4.y = TEXEL_SIZE.y;
  highp vec2 tmpvar_5;
  tmpvar_5.x = 0.0;
  tmpvar_5.y = TEXEL_SIZE.y;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = (_glesMultiTexCoord0.xy - tmpvar_2);
  xlv_TEXCOORD2 = (_glesMultiTexCoord0.xy + tmpvar_3);
  xlv_TEXCOORD3 = (_glesMultiTexCoord0.xy + tmpvar_4);
  xlv_TEXCOORD4 = (_glesMultiTexCoord0.xy - tmpvar_5);
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D PRESSURE;
uniform sampler2D VELOCITY;
uniform highp float FLOAT_MIN;
uniform highp float FLOAT_MAX;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
varying highp vec2 xlv_TEXCOORD3;
varying highp vec2 xlv_TEXCOORD4;
void main ()
{
  highp vec2 velocity_1;
  highp float tmpvar_2;
  tmpvar_2 = (FLOAT_MAX - FLOAT_MIN);
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (PRESSURE, xlv_TEXCOORD1);
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture2D (PRESSURE, xlv_TEXCOORD2);
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (PRESSURE, xlv_TEXCOORD3);
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (PRESSURE, xlv_TEXCOORD4);
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (VELOCITY, xlv_TEXCOORD0);
  highp vec2 tmpvar_8;
  tmpvar_8.x = (((tmpvar_4.x * tmpvar_2) + FLOAT_MIN) - ((tmpvar_3.x * tmpvar_2) + FLOAT_MIN));
  tmpvar_8.y = (((tmpvar_5.x * tmpvar_2) + FLOAT_MIN) - ((tmpvar_6.x * tmpvar_2) + FLOAT_MIN));
  velocity_1 = (((tmpvar_2 * tmpvar_7.xy) + vec2(FLOAT_MIN)) - tmpvar_8);
  velocity_1 = ((velocity_1 - vec2(FLOAT_MIN)) / tmpvar_2);
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = velocity_1;
  gl_FragData[0] = tmpvar_9;
}

]===],
	},
}

end