#DEFPARAMS
MOTION_VECTOR   = {"MOTION_VECTOR", TEXTURE2D, "MOTION_VECTOR"},
CUR_FRAME       = {"CUR_FRAME", TEXTURE2D, "CUR_FRAME"},
CUR_COLOR       = {"CUR_COLOR", TEXTURE2D, "CUR_COLOR"},
COLOR_MODE      = {"COLOR_MODE", FLOAT, "0.0"},
FLUID_COLOR     = {"FLUID_COLOR", VEC3, "1.0, 0.0, 0.0"},
DYE_DIFFICULTY  = {"DYE_DIFFICULTY", FLOAT, "0.0"},
DYE_MASK        = {"DYE_MASK", TEXTURE2D, "DYE_MASK"},
MASK_VALID      = {"MASK_VALID", FLOAT, "0.0"},
INVERT_MASK     = {"INVERT_MASK", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName  = "DyeColorStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D MOTION_VECTOR;
sampler2D CUR_FRAME;
sampler2D CUR_COLOR;
float     COLOR_MODE;
float3    FLUID_COLOR;
float     DYE_DIFFICULTY;
sampler2D DYE_MASK;
float     MASK_VALID;
float     INVERT_MASK;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

float4 frag(v2f i) : SV_Target
{
    float2 motion_vector = 2.0 * (tex2D(MOTION_VECTOR, i.uv).xy - float2(0.5, 0.5)); //[0, 1] -> [-1, 1]
    float  epsilon       = 0.15; //motion vector must be sufficiently strong
    float  dye_flag      = length(motion_vector) > epsilon ? 1.0 : 0.0;
    float color_epsilon  = 1.0 - clamp(DYE_DIFFICULTY, 0.0, 1.0);
    float4 cur_color     = tex2D(CUR_COLOR, i.uv);
    dye_flag             = cur_color.a > color_epsilon ? 0.0 : dye_flag;
    if(MASK_VALID > 0.)
    {
        float mask_alpha = INVERT_MASK > 0.0 ? 1.0 - tex2D(DYE_MASK, i.uv).a : tex2D(DYE_MASK, i.uv).a;
        dye_flag = mask_alpha > 0.0 ? dye_flag : 0.0;
    }

    int color_mode = int(COLOR_MODE + 0.5);
    if(color_mode == 0)
    {
        return dye_flag > 0.0 ? float4(FLUID_COLOR, 1.0) : cur_color;
    }
    else
    {
        float4 frame_color = tex2D(CUR_FRAME, i.uv);
        return dye_flag > 0.0 ? frame_color : cur_color;
    }
}
ENDCG
#END