function DefineParams()
	Properties = 
	{
		
COLOR        = {"COLOR", TEXTURE2D, "COLOR"},
DISPLAY_MASK = {"DISPLAY_MASK", TEXTURE2D, "DISPLAY_MASK"},
MASK_VALID   = {"MASK_VALID", FLOAT, "0.0"},
INVERT_MASK  = {"INVERT_MASK", FLOAT, "0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "DisplayStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "COLOR",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DISPLAY_MASK",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_VALID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "INVERT_MASK",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D COLOR;
uniform sampler2D DISPLAY_MASK;
uniform highp float MASK_VALID;
uniform highp float INVERT_MASK;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp float mask_alpha_1;
  highp vec4 color_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture2D (COLOR, xlv_TEXCOORD0);
  color_2 = tmpvar_3;
  lowp float tmpvar_4;
  if ((INVERT_MASK > 0.0)) {
    tmpvar_4 = (1.0 - texture2D (DISPLAY_MASK, xlv_TEXCOORD0).w);
  } else {
    tmpvar_4 = texture2D (DISPLAY_MASK, xlv_TEXCOORD0).w;
  };
  mask_alpha_1 = tmpvar_4;
  if ((MASK_VALID > 0.0)) {
    color_2.w = min (mask_alpha_1, color_2.w);
  };
  gl_FragData[0] = color_2;
}

]===],
	},
}

end