function DefineParams()
	Properties = 
	{
		
PRESSURE        = {"PRESSURE", TEXTURE2D, "PRESSURE"},
PRESSURE_CONFIG = {"PRESSURE_CONFIG",  FLOAT, "0.8"},
FLOAT_MIN       = {"FLOAT_MIN", FLOAT, "-100.0"},
FLOAT_MAX       = {"FLOAT_MAX", FLOAT, "100.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "ClearPressureStep"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "PRESSURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PRESSURE_CONFIG",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FLOAT_MIN",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FLOAT_MAX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D PRESSURE;
uniform highp float PRESSURE_CONFIG;
uniform highp float FLOAT_MIN;
uniform highp float FLOAT_MAX;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 normalized_pressure_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (PRESSURE, xlv_TEXCOORD0);
  normalized_pressure_1 = tmpvar_2;
  highp float tmpvar_3;
  tmpvar_3 = (FLOAT_MAX - FLOAT_MIN);
  normalized_pressure_1.x = (((PRESSURE_CONFIG * 
    ((normalized_pressure_1.x * tmpvar_3) + FLOAT_MIN)
  ) - FLOAT_MIN) / tmpvar_3);
  _glesFragData[0] = normalized_pressure_1;
}

]===],
	},
}

end