
#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "maintex" },
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "FindEdge"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
float2    ImageSize;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float unitx = 1.0/ImageSize.x;
	float unity = 1.0/ImageSize.y;
	float3 left1 = tex2D(_MainTex,i.uv + float2(-unitx,-unity)).rgb;
	float3 left2 = tex2D(_MainTex,i.uv + float2(-unitx,0.0)).rgb;
	float3 left3 = tex2D(_MainTex,i.uv + float2(-unitx,unity)).rgb;
	float3 mid1 = tex2D(_MainTex,i.uv + float2(0.0,-unity)).rgb;
	float3 mid2 = tex2D(_MainTex,i.uv + float2(0.0,unity)).rgb;
	float3 right1 = tex2D(_MainTex,i.uv + float2(unitx,-unity)).rgb;
	float3 right2 = tex2D(_MainTex,i.uv + float2(unitx,0.0)).rgb;
	float3 right3 = tex2D(_MainTex,i.uv + float2(unitx,unity)).rgb;
	float3 resultx = (right1 + right2 + right3) - (left1 + left2 + left3);
	float3 resulty = (left1 + mid1 + right1) - (left3 + mid2 + right3);

	float3 rgb = smoothstep(float3(0.0,0.0,0.0), float3(1.0,1.0,1.0),(abs(resultx) + abs(resulty) ) * 0.5 );

	#ifdef POST_EFFECT_ALPHA_OFF
		rgb = float3(1.0,1.0,1.0) - rgb;
        return float4(rgb,1.0);
	#elif POST_EFFECT_ALPHA_ON
		float alpha = max(rgb.r, rgb.g);
		alpha = max(rgb.b, alpha);
		rgb = float3(1.0,1.0,1.0) - rgb;
		return float4(rgb, alpha);
	#endif
}
ENDCG
#END
