
#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "maintex" },
_DistortCenter = { "distortiont center", VEC2, "0.5, 0.5"},
_Convergence = { "convergence", FLOAT, "1.0" },
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "CCLens"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"
#include "distortion.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
float2 _Radius;
float2 _DistortCenter;
float _Convergence;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}


float4 frag(v2f i) : SV_Target
{      
    float k1 = clamp(_Convergence, -1.0, 2.0);
	float k2 = 0.0;
	
	float2 uv = (i.uv  - _DistortCenter ) / _Radius;
	if( dot(uv,uv) > 1.0 && k1 < 0.0 ) return float4(0.0,0.0,0.0,1.0);
	
    uv = brownConradyDistortion( uv, k1, k2 );
    
	uv = (uv * _Radius + _DistortCenter);	// restore -> [0:1]

	// darken outside uv range
	float2 uv2 = abs(uv * 2. - 1.);
	float2 border = 1.0 - step(float2(1.0,1.0),uv2);

	#ifdef POST_EFFECT_ALPHA_OFF
		float3 c = tex2D(_MainTex, uv ).rgb;
		c *= border.x * border.y;
		return float4(c, 1.);
	#elif POST_EFFECT_ALPHA_ON
		float4 c = tex2D(_MainTex, uv );
		c.rgb *= border.x * border.y;
		return c;
	#endif
}
ENDCG
#END
