
#DEFPARAMS
_MainTex = { "Main Color", TEXTURE2D, "maintex" },
_MaskTex = { "Mask Texture", TEXTURE2D, "masktex"},
#END

#DEFTAG
ShaderName = "MaskQuad"
RenderQueue = "TRANSPARENT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "commonvar.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
sampler2D _MaskTex;


v2f vert(appdata v)
{
	v2f o;
	float4 pos = v.vertex * (1.0 / v.vertex.w);
	pos = mul(LOCALWORLD_TRANSFORM, pos);
	pos.w = 1.0;
	pos.x = pos.x + WORLD_POSITION.x;
	pos.y = pos.y + WORLD_POSITION.y;
	o.vertex = pos;
	//o.vertex = v.vertex;
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{

  float4 mainColor = tex2D(_MainTex,i.uv);
  float4 maskColor = tex2D(_MaskTex,i.uv);
  
  float4 colorR = float4(mainColor.r,mainColor.g,mainColor.b,maskColor.r);
  return colorR;
}
ENDCG
#END
