

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
TEXTURE_SHADOW_DEPTH = { "main Color", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "simple"
RenderQueue = "Opaque"
#END

#DEFPASS ForwardBase
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { FORWARDBASE }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#pragma multi_compile_fwdbase
	#include "light.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float2 uv : TEXCOORD0;
		float3 normal : NORMAL;
		ANI_ATTRIBUTE
	};

	struct v2f
	{
		float2 uv : TEXCOORD0;
		float4 vertex : SV_POSITION;

		float4 worldnormal : TEXCOORD5;
		float3 viewDirection : TEXCOORD1;
		float3 lightDirection : TEXCOORD2;
		float3 LightCoord : TEXCOORD3;
		float  OrigDepth : TEXCOORD4; 
	};

	sampler2D TEXTURE_DIFFUSE;
	float3 LIGHT_CAMERA_LINEARPARAM;

	v2f vert(appdata v)
	{
		COMPUTE_BONE_MATERIX(v);

		v2f o;
		float4 pos = ObjectToClipPos(v.vertex);
		o.vertex = UniformNDC(pos);
		o.uv = v.uv.xy;
		o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
		float3 worldpos = ObjectToWorldPos(v.vertex).xyz;		

		#ifdef DirLight
			o.viewDirection = (CAMERA_WORLDPOSITION - worldpos);
		#elif PointLight
			o.viewDirection =  (CAMERA_WORLDPOSITION - worldpos);
			o.lightDirection = (LIGHT_POSITION - worldpos);
		#elif SpotLight
			o.viewDirection =  (CAMERA_WORLDPOSITION - worldpos);
			o.lightDirection = (LIGHT_POSITION - worldpos);
		#else
			o.viewDirection = float3(0.0, 0.0, 1.0);
			o.lightDirection = float3(0.0, 0.0, 1.0);
		#endif

		#ifdef ShadowOn
			const float4x4 biasMatrix = float4x4(float4(0.5,0.0,0.0,0.0),
						float4(0.0,0.5,0.0,0.0),
						float4(0.0,0.0,0.5,0.0),
						float4(0.5,0.5,0.5,1.0));
			float4 newWorldPos = float4(worldpos, 0.0)-float4(0.005*o.worldnormal.xyz,0.0);
			float4 out_LightCoord = mul(LIGHT_CAMERA_PROJECTION, mul(LIGHT_CAMERA_VIEW, newWorldPos));
			float4 positionCS = mul(LIGHT_CAMERA_VIEW, newWorldPos);
			out_LightCoord = out_LightCoord / out_LightCoord.w;
			o.LightCoord = mul(biasMatrix, out_LightCoord);
			o.OrigDepth = ( -positionCS.z / positionCS.w - LIGHT_CAMERA_LINEARPARAM.x ) * LIGHT_CAMERA_LINEARPARAM.y;
		#endif

		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		// sample the texture
		float4 col = tex2D(TEXTURE_DIFFUSE, i.uv);
		
		float3 diffuse = float3(1.0, 1.0, 1.0);
		#ifdef ShadowOn
			float4 depthColor = tex2D(TEXTURE_SHADOW_DEPTH, i.uv);
			const float4 bitShifts = float4(1.0,
							1.0 / 256.0,
							1.0 / 65536.0,
							1.0 / 16777216.0);
			float TexDepth = dot(depthColor, bitShifts);

			#ifdef DirLight
				const half constant = 60.0;
				half3 vNormal    	= normalize( i.worldnormal );
				half3 vLight    	= normalize( -LIGHT_GIVEN_DIRECTION );
				half3 vView     	= normalize( i.viewDirection );
				half3 vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );	
			

				float expFactor = exp(constant * ( TexDepth - i.OrigDepth ) );
				if (expFactor > 1.0)
				{
					expFactor = 1.0;
				}

				diffuse = AMBIENT_COLOR + fDiffuse * LIGHT_COLOR * expFactor;
			#elif PointLight
				half dis = length( i.lightDirection );
				half disRange = clamp( dis * LIGHT_RANGE_INV, 0.0, 1.0 );
				fixed g_fAttenuation = (1.0 - disRange ) / ( LIGHT_ATTENUATION.x + disRange * LIGHT_ATTENUATION.y + disRange * disRange * LIGHT_ATTENUATION.z );

				half3 vNormal    	= normalize( i.worldnormal );
				
				half3  vLight    	= normalize( i.lightDirection );
				half3  vView     	= normalize( i.viewDirection  );
				half3  vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );		
				
				fixed attenAngle = clamp( 1.0 - ( LIGHT_INNER_DIFF_INV.x - dot(vLight, -LIGHT_GIVEN_DIRECTION) ) * LIGHT_INNER_DIFF_INV.y, 0.0, 1.0 );
				g_fAttenuation *= attenAngle;
				
				const half constant = 60.0;
				float expFactor = exp(constant * ( TexDepth - i.OrigDepth ) );
				if (expFactor > 1.0)
				{
					expFactor = 1.0;
				}
			
				diffuse = AMBIENT_COLOR + ( fDiffuse * g_fAttenuation ) * LIGHT_COLOR * expFactor;
			#endif
		#else
			#ifdef PointLight
				half dis = length( i.lightDirection );
				half disRange = clamp( dis * LIGHT_RANGE_INV, 0.0, 1.0 );
				fixed g_fAttenuation = (1.0 - disRange ) / ( LIGHT_ATTENUATION.x + disRange * LIGHT_ATTENUATION.y + disRange * disRange * LIGHT_ATTENUATION.z );

				half3 vNormal    	= normalize( i.worldnormal );
				
				half3  vLight    	= normalize( i.lightDirection );
				half3  vView     	= normalize( i.viewDirection );
				half3  vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );	
				
				diffuse = AMBIENT_COLOR + ( fDiffuse * g_fAttenuation ) * LIGHT_COLOR;
			#elif DirLight
				half3 vNormal    	= normalize( i.worldnormal );
				
				half3  vLight    	= normalize( -LIGHT_GIVEN_DIRECTION );
				half3  vView     	= normalize( i.viewDirection );
				half3  vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );		
				
				diffuse = AMBIENT_COLOR + fDiffuse * LIGHT_COLOR;
			#elif SpotLight
				half dis = length( i.lightDirection );
				half disRange = clamp( dis * LIGHT_RANGE_INV, 0.0, 1.0 );
				fixed g_fAttenuation = (1.0 - disRange ) / ( LIGHT_ATTENUATION.x + disRange * LIGHT_ATTENUATION.y + disRange * disRange * LIGHT_ATTENUATION.z );

				half3 vNormal    	= normalize( i.worldnormal );
				
				half3  vLight    	= normalize( i.lightDirection );
				half3  vView     	= normalize( i.viewDirection );
				half3  vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );		
				
				fixed attenAngle = clamp( 1.0 - ( LIGHT_INNER_DIFF_INV.x - dot(vLight, -LIGHT_GIVEN_DIRECTION) ) * LIGHT_INNER_DIFF_INV.y, 0.0, 1.0 );
				g_fAttenuation *= attenAngle;
				
				diffuse = AMBIENT_COLOR + ( fDiffuse * g_fAttenuation ) * LIGHT_COLOR;

			#else
				diffuse = LIGHT_COLOR;
			#endif
		#endif

		return float4( diffuse * col.rgb, col.a );
	}
	ENDCG
#END

#DEFPASS ForwardAdd
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { FORWARDADD }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#pragma multi_compile_fwdadd
	#include "light.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float2 uv : TEXCOORD0;
		float3 normal : NORMAL;
		ANI_ATTRIBUTE
	};

	struct v2f
	{
		float2 uv : TEXCOORD0;
		float4 vertex : SV_POSITION;

		float4 worldnormal : TEXCOORD5;
		float3 viewDirection : TEXCOORD1;
		float3 lightDirection : TEXCOORD2;
		float3 LightCoord : TEXCOORD3;
		float  OrigDepth : TEXCOORD4; 
	};

	sampler2D TEXTURE_DIFFUSE;
	float3 LIGHT_CAMERA_LINEARPARAM;

	v2f vert(appdata v)
	{
		COMPUTE_BONE_MATERIX(v);

		v2f o;
		float4 pos = ObjectToClipPos(v.vertex);
		o.vertex = UniformNDC(pos);
		o.uv = v.uv.xy;
		o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
		float3 worldpos = ObjectToWorldPos(v.vertex).xyz;		

		#ifdef DirLight
			o.viewDirection = (CAMERA_WORLDPOSITION - worldpos);
		#elif PointLight
			o.viewDirection =  (CAMERA_WORLDPOSITION - worldpos);
			o.lightDirection = (LIGHT_POSITION - worldpos);
		#elif SpotLight
			o.viewDirection =  (CAMERA_WORLDPOSITION - worldpos);
			o.lightDirection = (LIGHT_POSITION - worldpos);
		#else
			o.viewDirection = float3(0.0, 0.0, 1.0);
			o.lightDirection = float3(0.0, 0.0, 1.0);
		#endif

		#ifdef ShadowOn
			const float4x4 biasMatrix = float4x4(float4(0.5,0.0,0.0,0.0),
						float4(0.0,0.5,0.0,0.0),
						float4(0.0,0.0,0.5,0.0),
						float4(0.5,0.5,0.5,1.0));
			float4 newWorldPos = float4(worldpos, 0.0)-float4(0.005*o.worldnormal.xyz,0.0);
			float4 out_LightCoord = mul(LIGHT_CAMERA_PROJECTION, mul(LIGHT_CAMERA_VIEW, newWorldPos));
			float4 positionCS = mul(LIGHT_CAMERA_VIEW, newWorldPos);
			out_LightCoord = out_LightCoord / out_LightCoord.w;
			o.LightCoord = mul(biasMatrix, out_LightCoord);
			o.OrigDepth = ( -positionCS.z / positionCS.w - LIGHT_CAMERA_LINEARPARAM.x ) * LIGHT_CAMERA_LINEARPARAM.y;
		#endif

		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		// sample the texture
		float4 col = tex2D(TEXTURE_DIFFUSE, i.uv);
		
		float3 diffuse = float3(1.0, 1.0, 1.0);
		#ifdef ShadowOn
			float4 depthColor = tex2D(TEXTURE_SHADOW_DEPTH, i.uv);
			const float4 bitShifts = float4(1.0,
							1.0 / 256.0,
							1.0 / 65536.0,
							1.0 / 16777216.0);
			float TexDepth = dot(depthColor, bitShifts);

			#ifdef DirLight
				const half constant = 60.0;
				half3 vNormal    	= normalize( i.worldnormal );
				half3 vLight    	= normalize( -LIGHT_GIVEN_DIRECTION );
				half3 vView     	= normalize( i.viewDirection );
				half3 vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );	
			

				float expFactor = exp(constant * ( TexDepth - i.OrigDepth ) );
				if (expFactor > 1.0)
				{
					expFactor = 1.0;
				}

				diffuse = AMBIENT_COLOR + fDiffuse * LIGHT_COLOR * expFactor;
			#elif PointLight
				half dis = length( i.lightDirection );
				half disRange = clamp( dis * LIGHT_RANGE_INV, 0.0, 1.0 );
				fixed g_fAttenuation = (1.0 - disRange ) / ( LIGHT_ATTENUATION.x + disRange * LIGHT_ATTENUATION.y + disRange * disRange * LIGHT_ATTENUATION.z );

				half3 vNormal    	= normalize( i.worldnormal );
				
				half3  vLight    	= normalize( i.lightDirection );
				half3  vView     	= normalize( i.viewDirection  );
				half3  vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );		
				
				fixed attenAngle = clamp( 1.0 - ( LIGHT_INNER_DIFF_INV.x - dot(vLight, -LIGHT_GIVEN_DIRECTION) ) * LIGHT_INNER_DIFF_INV.y, 0.0, 1.0 );
				g_fAttenuation *= attenAngle;
				
				const half constant = 60.0;
				float expFactor = exp(constant * ( TexDepth - i.OrigDepth ) );
				if (expFactor > 1.0)
				{
					expFactor = 1.0;
				}
			
				diffuse = AMBIENT_COLOR + ( fDiffuse * g_fAttenuation ) * LIGHT_COLOR * expFactor;
			#endif
		#else
			#ifdef PointLight
				half dis = length( i.lightDirection );
				half disRange = clamp( dis * LIGHT_RANGE_INV, 0.0, 1.0 );
				fixed g_fAttenuation = (1.0 - disRange ) / ( LIGHT_ATTENUATION.x + disRange * LIGHT_ATTENUATION.y + disRange * disRange * LIGHT_ATTENUATION.z );

				half3 vNormal    	= normalize( i.worldnormal );
				
				half3  vLight    	= normalize( i.lightDirection );
				half3  vView     	= normalize( i.viewDirection );
				half3  vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );	
				
				diffuse = AMBIENT_COLOR + ( fDiffuse * g_fAttenuation ) * LIGHT_COLOR;
			#elif DirLight
				half3 vNormal    	= normalize( i.worldnormal );
				
				half3  vLight    	= normalize( -LIGHT_GIVEN_DIRECTION );
				half3  vView     	= normalize( i.viewDirection );
				half3  vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );		
				
				diffuse = AMBIENT_COLOR + fDiffuse * LIGHT_COLOR;
			#elif SpotLight
				half dis = length( i.lightDirection );
				half disRange = clamp( dis * LIGHT_RANGE_INV, 0.0, 1.0 );
				fixed g_fAttenuation = (1.0 - disRange ) / ( LIGHT_ATTENUATION.x + disRange * LIGHT_ATTENUATION.y + disRange * disRange * LIGHT_ATTENUATION.z );

				half3 vNormal    	= normalize( i.worldnormal );
				
				half3  vLight    	= normalize( i.lightDirection );
				half3  vView     	= normalize( i.viewDirection );
				half3  vHalf     	= normalize( vLight + vView );
				half dotLightNormal= dot( vLight, vNormal );
				half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );		
				
				fixed attenAngle = clamp( 1.0 - ( LIGHT_INNER_DIFF_INV.x - dot(vLight, -LIGHT_GIVEN_DIRECTION) ) * LIGHT_INNER_DIFF_INV.y, 0.0, 1.0 );
				g_fAttenuation *= attenAngle;
				
				diffuse = AMBIENT_COLOR + ( fDiffuse * g_fAttenuation ) * LIGHT_COLOR;

			#else
				diffuse = LIGHT_COLOR;
			#endif
		#endif

		return float4( diffuse * col.rgb, col.a );
	}
	ENDCG
#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "light.inc"

	struct appdata
	{
		float4 vertex : POSITION;
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
		float  Depth : TEXCOORD0;
	};

	
	float3 CAMERA_LINEARPARAMBIAS;

	v2f vert(appdata v)
	{
		v2f o;
		float4 pos = ObjectToClipPos(v.vertex);
		o.vertex = UniformNDC(pos);

		float3 worldpos = ObjectToWorldPos(v.vertex).xyz;	

		float4 position_cameraspace = mul(CAMERA_VIEW, float4(worldpos, 1.0));
		float3 PositionCS = position_cameraspace.xyz / position_cameraspace.w;

		float Distance = -PositionCS.z;

		o.Depth = ( Distance - CAMERA_LINEARPARAMBIAS.x ) * CAMERA_LINEARPARAMBIAS.y;		

		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		const float4 bias = float4(1.0 / 255.0,
                1.0 / 255.0,
                1.0 / 255.0,
                0.0);

		float r = i.Depth;		
		float g = frac(i.Depth * 256.0);		// fract
		float b = frac(i.Depth * 65536.0);
		float a = frac(i.Depth * 16777216.0);
		float4 colour = float4(r, g, b, a);
	
		return colour - (colour.yzww * bias);
	}
	ENDCG
#END
