

#DEFPARAMS
TEXTURE_DIFFUSE = {"Main Tex", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "Quad"
RenderQueue = "Background"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;

v2f vert(appdata v)
{
  v2f o;
  float4 out_pos = v.vertex * (1.0 / v.vertex.w);
  out_pos = mul(LOCALWORLD_TRANSFORM, out_pos);
  out_pos.w = 1.0;
  out_pos.x = out_pos.x + WORLD_POSITION.x;
  out_pos.y = out_pos.y + WORLD_POSITION.y;
  o.vertex = UniformNDC(out_pos);
  o.uv = v.uv;
  return o;
}

float4 frag(v2f i) : SV_Target
{
  return tex2D(TEXTURE_DIFFUSE, i.uv);
}

ENDCG
#END
