﻿

#include "common.inc"
#include "shadow.inc"

#ifndef OLDLIGHTPBR_INC
#define OLDLIGHTPBR_INC


struct appdata
{
	float4 in_Position : POSITION;
	float3 in_Normal : NORMAL;
	float3 in_Tangent : TANGENT;
	float2 in_Coordinate : TEXCOORD0;
};

void TransfromWorldPosition(float4 in_Position, float4 in_Normal, float3 in_Tangent,
out float4 out_Position, out float3 out_PositionWS, out float3 out_NormalWS, 
out float3x3 W2T_TBN, out float3x3 T2W_TBN)
{

	float4x4 in_ViewPorj = CAMERA_VIEWPROJ;
	float4x4 in_Transfrom = LOCALWORLD_TRANSFORM;
	float3x3 in_WorldRotation = (float3x3)LOCALWORLD_TRANSFORM;

	out_Position.xyzw = mul(in_ViewPorj, mul(in_Transfrom, in_Position.xyzw));
	out_Position.xyzw = UniformNDC(out_Position.xyzw);

	out_PositionWS  = float3(mul(in_Transfrom, in_Position).xyz);
    out_NormalWS = normalize(mul(in_WorldRotation, in_Normal.xyz));

	float3 out_TangentWS =  normalize(mul(in_WorldRotation, in_Tangent));
	float3 out_BiTangentWS = (cross(out_TangentWS, out_NormalWS));
//             这里glsl和hlsl在构造矩阵的时候是有区别的注意
//	T2W_TBN = float3x3(out_TangentWS,out_BiTangentWS,out_NormalWS);//从切线空间转到世界空间的矩阵
//	W2T_TBN = float3x3(
//		float3(out_TangentWS.x,out_BiTangentWS.x,out_NormalWS.x),
//		float3(out_TangentWS.y,out_BiTangentWS.y,out_NormalWS.y),
//		float3(out_TangentWS.z,out_BiTangentWS.z,out_NormalWS.z));//从世界空间转到切线空间的矩阵

	W2T_TBN = float3x3(out_TangentWS,out_BiTangentWS,out_NormalWS);//从切线空间转到世界空间的矩阵
	T2W_TBN = float3x3(
		float3(out_TangentWS.x,out_BiTangentWS.x,out_NormalWS.x),
		float3(out_TangentWS.y,out_BiTangentWS.y,out_NormalWS.y),
		float3(out_TangentWS.z,out_BiTangentWS.z,out_NormalWS.z));//从世界空间转到切线空间的矩阵
}

//float3 LIGHT_GIVEN_DIRECTION;
//float LIGHT_RANGE_INV;
//float4 LIGHT_ATTENUATION;
//float3 LIGHT_COLOR;
//float2 LIGHT_INNER_DIFF_INV;

void GetLightDirAndViewDir(in float3x3 W2T_TBN,in float3 in_PositionWS, out float3 out_ViewDirection, out float3 out_LightDirection)
{
#define in_LightDirection LIGHT_GIVEN_DIRECTION
#define in_LightPosition LIGHT_POSITION
	float3 in_CameraPosition = CAMERA_WORLDPOSITION;
	#ifdef DirLight
		out_ViewDirection =  mul(W2T_TBN, (in_CameraPosition - in_PositionWS));
	    out_LightDirection = mul(W2T_TBN, in_LightDirection);
	#elif PointLight
		out_ViewDirection =  mul(W2T_TBN, (in_CameraPosition - in_PositionWS));
		out_LightDirection = mul(W2T_TBN, (in_PositionWS - in_LightPosition));
	#elif SpotLight
		out_ViewDirection =  mul(W2T_TBN, (in_CameraPosition - in_PositionWS));
		out_LightDirection = mul(W2T_TBN, (in_PositionWS - in_LightPosition));
	#else
		out_ViewDirection = float3(0.0, 0.0, 1.0);
		out_LightDirection = float3(0.0, 0.0, 1.0);
	#endif

#undef in_LightDirection
#undef in_LightPosition
}

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float3 out_ViewDir: TEXCOORD1;
	float3 out_LightDir : TEXCOORD2;
	float3 T2W_TBN_X : TEXCOORD3;
	float3 T2W_TBN_Y : TEXCOORD4;
	float3 T2W_TBN_Z : TEXCOORD5;
	float4 vertex : SV_POSITION;
};

v2f lightVert(appdata v)
{
	float4 out_Position;
	float3 out_PositionWS;
	float3 out_NormalWS;
	float3x3 W2T_TBN;
	float3x3 T2W_TBN;
	float3 lightDir;
	float3 viewDir;

	TransfromWorldPosition(v.in_Position, float4(v.in_Normal,1.0), v.in_Tangent, 
	out_Position, out_PositionWS, out_NormalWS, W2T_TBN, T2W_TBN);
    
	GetLightDirAndViewDir(W2T_TBN, out_PositionWS, viewDir, lightDir);

	v2f o;
	o.vertex = out_Position;
	o.out_Coordinate = v.in_Coordinate.xy;
	o.out_ViewDir = viewDir;
	o.out_LightDir = lightDir;
	o.T2W_TBN_X = T2W_TBN[0];
	o.T2W_TBN_Y = T2W_TBN[1];
	o.T2W_TBN_Z = T2W_TBN[2];
	return o;
}

sampler2D TEXTURE_ALDEBO;
sampler2D TEXTURE_METALLIC;
sampler2D TEXTURE_ROUGHNESS;
sampler2D TEXTURE_AMR;
sampler2D TEXTURE_NORMAL;
samplerCUBE SKY_BOX;

void GetPBRProperty(in float2 in_Coordinate, 
out float3 albedo, out float metallic, out float roughness, 
out float3 Normal_TangentSpace, out float3 F0)
{
	#define albedoMap TEXTURE_ALDEBO
	#define metallicMap TEXTURE_METALLIC
	#define roughnessMap TEXTURE_ROUGHNESS
	#define AoRoughnessMetallicMap TEXTURE_AMR
	#define normalMap TEXTURE_NORMAL

	albedo = pow(tex2D(albedoMap, in_Coordinate).rgb, float3(2.2,2.2,2.2));
    float3 ao_roughness_metallic = tex2D(AoRoughnessMetallicMap,in_Coordinate).rgb;
    float ao = ao_roughness_metallic.r;

    roughness = ao_roughness_metallic.g;
    metallic = ao_roughness_metallic.b;
	albedo = albedo * ao; //考虑ao
		
	float3 tangentNormal_tmp = tex2D(normalMap, in_Coordinate).xyz * 2.0 - 1.0;
	Normal_TangentSpace = normalize(tangentNormal_tmp);

	F0 = float3(0.04,0.04,0.04);
	F0 = lerp(F0, albedo, metallic);
}

void GetLightAttColorAndColor(float3 in_LightDirection,
out float3 out_LightDirection, out float3 out_LightColor)
{
//float3 LIGHT_GIVEN_DIRECTION;
//float LIGHT_RANGE_INV;
//float4 LIGHT_ATTENUATION;
//float3 LIGHT_COLOR;
//float2 LIGHT_INNER_DIFF_INV;

#define in_RangeInv LIGHT_RANGE_INV
#define in_LinghtAtten LIGHT_ATTENUATION
#define in_LightColor LIGHT_COLOR
#define in_vInner_DiffInv LIGHT_INNER_DIFF_INV
#define in_SpotDirection LIGHT_GIVEN_DIRECTION

	#ifdef PointLight
		// calculate per-light

		float distance = length( in_LightDirection );
		float distanceRange = clamp( distance * in_RangeInv, 0.0, 1.0 );
		float attenuation = (1.0 - distanceRange) / ( in_LinghtAtten.x + distanceRange * in_LinghtAtten.y + distanceRange * distanceRange * in_LinghtAtten.z );

		out_LightDirection =  in_LightDirection;
		out_LightColor = in_LightColor*attenuation;
	#elif SpotLight
		float3 vLight = normalize(-in_LightDirection);
		float distance = length( in_LightDirection );
		float distanceRange = clamp( distance * in_RangeInv, 0.0, 1.0 );
		float attenuation = (1.0 - distanceRange ) / ( in_LinghtAtten.x + distanceRange * in_LinghtAtten.y + distanceRange * distanceRange * in_LinghtAtten.z );

	    float attenAngle = clamp( 1.0 - ( in_vInner_DiffInv.x - dot(vLight, -in_SpotDirection) ) * in_vInner_DiffInv.y, 0.0, 1.0 );
	    attenuation *= attenAngle;
	    out_LightColor = in_LightColor*attenuation;
	    out_LightDirection = in_LightDirection;
	#elif DirLight
		out_LightDirection = in_LightDirection;
		out_LightColor = LIGHT_COLOR;
	#else
	    out_LightDirection = float3(0.0, 0.0, 1.0);
		out_LightColor = float3(0.0, 0.0, 0.0);
	#endif

#undef in_RangeInv
#undef in_LinghtAtten
#undef in_LightColor
#undef in_vInner_DiffInv
}

void PbrLightingSurface(float3 in_Normal, float3 in_LightDirection, float3 in_ViewDirection,
float3 albedo, float metallic, float roughness, float3 in_LightColor,
float3 F0, out float3 out_Diffuse, out float3 out_Specular)
{
	const float PI = 3.14159265359;

	// reflectance equation
	// light output
	float3 vNormal = normalize(in_Normal);

	float length = sqrt(dot(in_ViewDirection,in_ViewDirection));
	length = 1.0/length;
	float3 vView=in_ViewDirection*length;

	float3 vLight = normalize(-in_LightDirection);
	float3 vHalf = normalize(vView + vLight);
	
	// Cook-Torrance BRDF
	// DistributionGGX
	float NDF;
	//------------------------------------------
	{
		float a = roughness*roughness;
		float a2 = a*a;
		float NdotH = max( dot(vNormal, vHalf) , 0.0 );
		float NdotH2 = NdotH * NdotH;

		float nom	 = a2;
		float denom = (NdotH2 * (a2 - 1.0) + 1.0);
		denom = PI * denom * denom;

		NDF = nom / denom;

	}
	//------------------------------------------

	//GeometrySmith
	float G;
	//------------------------------------------
	{
		float NdotV = max(dot(vNormal, vView), 0.0);
		float NdotL = max(dot(vNormal, vLight), 0.0);

		float a = roughness;
		float lambdaV = NdotL * (NdotV * (1.0 - a) + a);
    	float lambdaL = NdotV * (NdotL * (1.0 - a) + a);

		G = 0.5 / (lambdaV + lambdaL + 1e-5f);
	}
	//------------------------------------------

	//fresnelSchlick
	float3  F;
	//------------------------------------------
	{
		float cosTheta = max(dot(vHalf, vView), 0.0);
		F = F0 + (1.0 - F0) * pow(1.0 - cosTheta, 5.0);
	}
	//------------------------------------------
	// Main Physically Based BRDF
	// Derived from Disney work and based on Torrance-Sparrow micro-facet model
	//
	//   BRDF = kD / pi + kS * (D * V * F) / 4
	//   I = BRDF * NdotL
	float3 nominator		= NDF * G * F *3.14;
	float3 specular = nominator;// / denominator;

	// kS is equal to Fresnel
	float3 kS = F;
	// for energy conservation, the diffuse and specular light can't
	// be above 1.0 (unless the surface emits light); to preserve this
	// relationship the diffuse component (kD) should equal 1.0 - kS.
	float3 kD = float3(1.0,1.0,1.0) - kS;
	// multiply kD by the inverse metalness such that only non-metals
	// have diffuse lighting, or a linear blend if partly metal (pure metals
	// have no diffuse light).
	kD *= 1.0 - metallic;

	// scale light by NdotL
	float NdotL = max(dot(vNormal, vLight), 0.0);

	out_Diffuse = kD * albedo / PI * NdotL * in_LightColor;
	out_Specular =  specular * NdotL* in_LightColor;//(vNormal+vec3(1.0))/2.0;//
}

void PBRIBLLightingSurface(float3 albedo, float metallic, float roughness,
float3 in_Normal, float3 in_ViewDirection, float3 F0, float3x3 T2W_TBN,
out float3 IBL_diffuse, out float3 IBL_specular)
{
	// add by zjt
	in_Normal = normalize(in_Normal);
	in_ViewDirection = normalize(in_ViewDirection);
	float3 kS;// 反射部分 镜面效果 所占的比例
	//------------------------------------------	
	float cosTheta = max(dot(in_Normal, in_ViewDirection), 0.0);
	kS = F0 + (max(float3(1.0-roughness,1.0-roughness,1.0-roughness),F0) - F0) * pow(1.0 - cosTheta, 5.0);

	float3 worldnormal = mul(T2W_TBN, in_Normal);//镜面反射射线
	//------------------------------------------
	float3 kD = 1.0 - kS; // 折射 漫反射效果 所占的比例
	kD *= 1.0 - metallic;// 金属性越强，漫反射越少, 折射越多
#define skybox SKY_BOX
	const float MAX_REFLECTION_LOD = 8.0;
	float4 cubeColor = SAMPLE_TEXCUBE_LOD(skybox, worldnormal, MAX_REFLECTION_LOD);
	float3 irradiance = cubeColor.xyz;
	IBL_diffuse = (kD) * ( albedo ) * irradiance;//漫反射效果
		
	float3 R = reflect(-in_ViewDirection, in_Normal);//镜面反射射线
	R = mul(T2W_TBN, R);
	float3 prefilteredColor	= SAMPLE_TEXCUBE_LOD(skybox, R , MAX_REFLECTION_LOD*roughness ).rgb;

	float3 refColor = float3(0.04,0.04,0.04);
	refColor = lerp(refColor, albedo, metallic);

	float smoothness = 1.0-roughness;
	float surfaceReduction = 1.0-0.28*roughness*roughness*roughness; 
	float oneMinusReflectivity = 0.96 - metallic*0.04; 
	oneMinusReflectivity = smoothness + (1.0- oneMinusReflectivity);
	float grazingTerm = clamp(oneMinusReflectivity,0.0,1.0);

	float t = 1.0 - cosTheta;   // ala Schlick interpoliation
	t = t*t*t*t*t;
    refColor = lerp (refColor, float3(grazingTerm,grazingTerm,grazingTerm), t);
    IBL_specular = surfaceReduction * prefilteredColor * refColor;
}

float4 lightFrag(v2f i)
{
	// 采样贴图信息
	float2 in_Coordinate = i.out_Coordinate.xy;
    float3 albedo;
	float metallic;
	float roughness;
	float3 Normal_TangentSpace;
	float3 F0;
	GetPBRProperty(in_Coordinate, albedo, metallic, roughness, Normal_TangentSpace, F0);

	// 获取灯光信息
	float3 in_LightDirection = i.out_LightDir;
	float3 out_LightDirection;
	float3 out_LightColor;
	GetLightAttColorAndColor(in_LightDirection, out_LightDirection, out_LightColor);

	// surface shading
	float3 in_Normal = Normal_TangentSpace;
    float3 surfaceLightDir = out_LightDirection;
	float3 in_ViewDirection = i.out_ViewDir;
	float3 surfaceLightColor = out_LightColor;
	float3 out_Diffuse;
	float3 out_Specular;

	PbrLightingSurface(in_Normal, surfaceLightDir, in_ViewDirection,
	albedo, metallic, roughness, surfaceLightColor,
	F0, out_Diffuse, out_Specular);

	// surface ibl shading
	float3x3 T2W_TBN;
	T2W_TBN[0] = i.T2W_TBN_X;
	T2W_TBN[1] = i.T2W_TBN_Y;
	T2W_TBN[2] = i.T2W_TBN_Z;

	float3 IBL_diffuse;
	float3 IBL_specular;

	PBRIBLLightingSurface(albedo, metallic, roughness,
	in_Normal, in_ViewDirection, F0, T2W_TBN,
	IBL_diffuse, IBL_specular);

	//环境贴图对当前片元颜色的贡献
	float3 ambient =  IBL_diffuse + IBL_specular;
	//光源对当前片元颜色的贡献
	float3 color =  out_Specular + out_Diffuse + ambient;
	// gamma correct
	color = pow(color, float3(1.0/2.2,1.0/2.2,1.0/2.2));
	float4 fragColor = float4(color,1.0);
	return fragColor;
}

#endif
