
float4 LUT(float4 textureColor, sampler2D lookuptable)
{
   float blueColor = textureColor.b * 63.0;
   
   float2 quad1;
   quad1.y = floor(floor(blueColor) / 8.0);
   quad1.x = floor(blueColor) - (quad1.y * 8.0);
   
   float2 quad2;
   quad2.y = floor(ceil(blueColor) / 8.0);
   quad2.x = ceil(blueColor) - (quad2.y * 8.0);
   
   float2 texPos1;
   texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);
   texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);
   
   float2 texPos2;
   texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);
   texPos2.y = (quad2.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);
   
   float4 newColor1 = tex2D(lookuptable, texPos1);
   float4 newColor2 = tex2D(lookuptable, texPos2);
   
   float4 newColor = lerp(newColor1, newColor2, frac(blueColor));
   float4 finalColor = float4(newColor.rgb, textureColor.w);
   return finalColor;
}

float4 LUT_Hald(float4 textureColor, sampler2D lookuptable)
{
   float blueColor = textureColor.b * 63.0;
   float greenColor = textureColor.g * 63.0;
   
   float2 quad1;
   float floory = floor(floor(greenColor) / 8.0);
   quad1.y = floor(blueColor);
   quad1.x = floor(greenColor) - (floory * 8.0);
   
   float2 quad2;
   float ceily = floor(ceil(greenColor) / 8.0);
   quad2.y = ceil(blueColor);
   quad2.x = ceil(greenColor) - (ceily * 8.0);
   
   float2 texPos1;
   texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);
   texPos1.y = (quad1.y * 0.015625) + 0.5 / 512.0 + ((0.015625 - 1.0 / 512.0) * (floory / 7.0));
   
   float2 texPos2;
   texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);
   texPos2.y = (quad2.y * 0.015625) + 0.5 / 512.0 + ((0.015625 - 1.0 / 512.0) * (ceily / 7.0));
   
   float4 newColor1 = tex2D(lookuptable, texPos1);
   float4 newColor2 = tex2D(lookuptable, texPos2);
   
   float newBlue = lerp(newColor1.b, newColor2.b, frac(blueColor));
   float newGreen = lerp(newColor1.g, newColor2.g, frac(greenColor));
   float3 newColor = float3(newColor1.r, newGreen, newBlue);
   float4 finalColor = float4(newColor, textureColor.w);
   return finalColor;
}

float3 rgb2xyz(float3 c) {
    float3 tmp;
    tmp.x = (c.r > 0.04045) ? pow((c.r + 0.055) * 0.947867, 2.4) : c.r * 0.077399;
    tmp.y = (c.g > 0.04045) ? pow((c.g + 0.055) * 0.947867, 2.4) : c.g * 0.077399;
    tmp.z = (c.b > 0.04045) ? pow((c.b + 0.055) * 0.947867, 2.4) : c.b * 0.077399;
    tmp *= 100.0;
    float3x3 mat = {
        0.4124, 0.3576, 0.1805, 
        0.2126, 0.7152, 0.0722, 
        0.0193, 0.1192, 0.9505
    };
    return mul(tmp, mat);
}

float3 xyz2lab(float3 c) {
    float3 n = c / float3(95.047, 100, 108.883);
    float3 v;
    v.x = (n.x > 0.008856) ? pow(n.x, 0.333333) : (7.787 * n.x) + 0.137931;
    v.y = (n.y > 0.008856) ? pow(n.y, 0.333333) : (7.787 * n.y) + 0.137931;
    v.z = (n.z > 0.008856) ? pow(n.z, 0.333333) : (7.787 * n.z) + 0.137931;
    return float3((116.0 * v.y) - 16.0, 500.0 * (v.x - v.y), 200.0 * (v.y - v.z));
}

float3 rgb2lab(float3 c) {
    float3 lab = xyz2lab(rgb2xyz(c));
    return float3(lab.x * 0.01, 0.5 + lab.y * 0.003937, 0.5 + lab.z * 0.003937);
}

float3 lab2xyz(float3 c) {
    float fy = (c.x + 16.0) * 0.008620;
    float fx = c.y * 0.002 + fy;
    float fz = fy - c.z * 0.005;
    return float3(
        95.047 * ((fx > 0.206897) ? fx * fx * fx: (fx - 16.0 * 0.008620) * 0.128419), 
        100.000 * ((fy > 0.206897) ? fy * fy * fy: (fy - 16.0 * 0.008620) * 0.128419), 
        108.883 * ((fz > 0.206897) ? fz * fz * fz: (fz - 16.0 * 0.008620) * 0.128419)
    );
}

float3 xyz2rgb(float3 c) {
    float3x3 mat = {
        3.2406, -1.5372, -0.4986, 
        -0.9689, 1.8758, 0.0415, 
        0.0557, -0.2040, 1.0570
    };
    float3 v = mul(c * 0.01, mat);
    float3 r;
    r.x = (v.r > 0.0031308) ? ((1.055 * pow(v.r, 0.416667)) - 0.055) : 12.92 * v.r;
    r.y = (v.g > 0.0031308) ? ((1.055 * pow(v.g, 0.416667)) - 0.055) : 12.92 * v.g;
    r.z = (v.b > 0.0031308) ? ((1.055 * pow(v.b, 0.416667)) - 0.055) : 12.92 * v.b;
    return r;
}

float3 lab2rgb(float3 c) {
    return xyz2rgb(lab2xyz(float3(100.0 * c.x, 2.0 * 127.0 * (c.y - 0.5), 2.0 * 127.0 * (c.z - 0.5))));
}

inline float fsqr(float value)
{
    return value * value;
}

float4 encode(float2 v)
{
    float4 rgba;
    v += 128.0;

    int ix = int( v.x * 256.0 );
    int v1x = ix / 256;
    int v1y = ix - v1x * 256;

    rgba.r = float( v1x + 1 ) / 255.0;
    rgba.g = float( v1y + 1 ) / 255.0;

    int iy = int( v.y * 256.0);
    int v2x = iy / 256;
    int v2y = iy - v2x * 256;

    rgba.b = float( v2x + 1 ) / 255.0;
    rgba.a = float( v2y + 1 ) / 255.0;

    return rgba - 1./256.;
}


float2 decode(float4 c)
{
    float2 v = float2(0.0, 0.0);

    int ir = int(c.r*255.);
    int ig = int(c.g*255.);
    int irg = ir*256 + ig;
    v.x = float(irg) / 256.; 

    int ib = int(c.b*255.);
    int ia = int(c.a*255.);
    int iba = ib*256 + ia;
    v.y = float(iba) / 256.; 

    v -= 128.;
    return v;
}

inline float gauss(float x, float twoSigmaSqr)
{
    return exp( - float( x * x ) / twoSigmaSqr );
}

inline int getLevel(float luminance,float uLop) {
    return int(ceil(luminance * uLop));
}

inline float applyLevel(int level,float uLop) {
    return (float(level) - 0.5) / uLop;
}

inline float rvr(float x)
{
    float exp2x = exp(2.0 * x);
    return (exp2x - 1.0) / (exp2x + 1.0);
}


float3 lut(float3 c, sampler2D uLut)
{
    float2 rg = c.rg * float2(15./16.,15./16.) + float2(0.5/16.,0.5/16.);
    float b = c.b * 15.;
    float slice0=min(floor(b),15.0);
    float slice1=min(slice0+1.0,15.0);
    float slice_w=b-slice0;
    float3 color0=tex2D(uLut,float2((slice0+rg.x)*(1.0/16.0),rg.y)).xyz;
    float3 color1=tex2D(uLut,float2((slice1+rg.x)*(1.0/16.0),rg.y)).xyz;
    return lerp(color0, color1, slice_w);
}