
#ifndef FUR_INC
#define FUR_INC

struct SDirection
{
    float3 viewDirection;
    float3 lightDirection;
};

struct SSurface
{
    float4 uv;
    float3 worldPos;
	float3 worldnormal;
	float3 worldtangent;
    float3 worldbinormal;
    float3 viewDirection;
    float3 lightDirection;
    float furStep;
    float3 occlusionColor;
    float fresnelLV;
    float furDirLightExposure;
    float dirLightFilter;
};

#ifdef DirLight
    #define VIEW_DIRECTION(o, worldPos) o.viewDirection = (CAMERA_WORLDPOSITION - worldPos);
    #define LIGHT_DIRECTION(o)
#elif SpotLight
    #define VIEW_DIRECTION(o, worldPos) o.viewDirection = (CAMERA_WORLDPOSITION - worldPos);
    #define LIGHT_DIRECTION(o) o.lightDirection = (LIGHT_POSITION - worldPos);
#elif PointLight
    #define VIEW_DIRECTION(o, worldPos) o.viewDirection = (CAMERA_WORLDPOSITION - worldPos);
    #define LIGHT_DIRECTION(o) o.lightDirection = (LIGHT_POSITION - worldPos);
#else
    #define VIEW_DIRECTION(o, worldPos) o.viewDirection = float3(0.0, 0.0, 1.0);
    #define LIGHT_DIRECTION(o) o.lightDirection = float3(0.0, 0.0, 1.0);
#endif


float StrandSpecular(float3 T,float3 V,float3 L,float exponent)
   {
       float3 H = normalize(L+V);
       float dotTH = dot(T,H);
       float sinTH = sqrt(1- dotTH * dotTH);
       float dirAtten = smoothstep(-1,0,dotTH);
       return dirAtten*pow(sinTH,exponent);
   }

float3 CalFurLight(SSurface i)
{
	float3 diffuse = float3(1.0, 1.0, 1.0);
    #ifdef PointLight
        half dis = length( i.lightDirection );
        half disRange = clamp( dis * LIGHT_RANGE_INV, 0.0, 1.0 );
        fixed g_fAttenuation = (1.0 - disRange ) / ( LIGHT_ATTENUATION.x + disRange * LIGHT_ATTENUATION.y + disRange * disRange * LIGHT_ATTENUATION.z );

        half3 vNormal    	= normalize( i.worldnormal );

        half3  vLight    	= normalize( i.lightDirection );
        half3  vView     	= normalize( i.viewDirection );
        half3  vHalf     	= normalize( vLight + vView );
        half dotLightNormal= dot( vLight, vNormal );
        half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );

        diffuse = AMBIENT_COLOR + ( fDiffuse * g_fAttenuation ) * LIGHT_COLOR;
    #elif DirLight
        half3 vNormal    	= normalize( i.worldnormal );
        half3 vTangent      = normalize(i.worldtangent);
        half3 vBinormal     = normalize(i.worldbinormal);
        half3  vLight    	= normalize( -LIGHT_GIVEN_DIRECTION );
        half3  vView     	= normalize( i.viewDirection );
        half3  vHalf     	= normalize( vLight + vView );
        half dotLightNormal= dot( vLight, vNormal );
        //half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );

        float Occlusion = i.furStep * i.furStep;
        Occlusion +=0.04 ;
        float3 SHL = lerp (i.occlusionColor * AMBIENT_COLOR, AMBIENT_COLOR, Occlusion) ;
        float Fresnel = 1.0 - max(0.0, dot(vNormal, vView));
        float RimLight = Fresnel * Occlusion;
        RimLight *=RimLight;
        float3 rimColor = i.fresnelLV * AMBIENT_COLOR * RimLight;
        SHL += rimColor;
        float3 amibentColor = SHL;

        float NoL = dot(vLight, vNormal);
        float dirLightFactor = saturate(NoL+ i.dirLightFilter + i.furStep ) ;
        dirLightFactor *= i.furDirLightExposure;

        //float3 T1 = normalize(i.specExp.z*vNormal+vBinormal);
        //float3 T2 = normalize(i.specExp.w*vNormal+vBinormal);
        //float SPec1 =StrandSpecular (T1,vView,vLight,i.specExp.x) * i.furStep;
        //float SPec2 =StrandSpecular (T2,vView,vLight,i.specExp.y) * i.furStep;
        //float3 Specular  = SPec1*i.sPColor1  + SPec2*i.sPColor2;

        diffuse = amibentColor + dirLightFactor * LIGHT_COLOR;// + Specular;
    #elif SpotLight
        half dis = length( i.lightDirection );
        half disRange = clamp( dis * LIGHT_RANGE_INV, 0.0, 1.0 );
        fixed g_fAttenuation = (1.0 - disRange ) / ( LIGHT_ATTENUATION.x + disRange * LIGHT_ATTENUATION.y + disRange * disRange * LIGHT_ATTENUATION.z );

        half3 vNormal    	= normalize( i.worldnormal );

        half3  vLight    	= normalize( i.lightDirection );
        half3  vView     	= normalize( i.viewDirection );
        half3  vHalf     	= normalize( vLight + vView );
        half dotLightNormal= dot( vLight, vNormal );
        half fDiffuse = clamp( dotLightNormal, 0.0, 1.0 );

        fixed attenAngle = clamp( 1.0 - ( LIGHT_INNER_DIFF_INV.x - dot(vLight, -LIGHT_GIVEN_DIRECTION) ) * LIGHT_INNER_DIFF_INV.y, 0.0, 1.0 );
        g_fAttenuation *= attenAngle;

        diffuse = AMBIENT_COLOR + ( fDiffuse * g_fAttenuation ) * LIGHT_COLOR;
    #else
        float3 vNormal = normalize( i.worldnormal );
        float3 vView = normalize( i.viewDirection );
        float Occlusion = i.furStep * i.furStep;
        Occlusion +=0.04 ;
        float3 SHL = lerp (i.occlusionColor * AMBIENT_COLOR, AMBIENT_COLOR, Occlusion) ;
        float Fresnel = 1.0 - max(0.0, dot(vNormal, vView));
        float RimLight = Fresnel * Occlusion;
        RimLight *=RimLight;
        float3 rimColor = i.fresnelLV * AMBIENT_COLOR * RimLight;
        SHL += rimColor;
        diffuse = SHL;
    #endif
    return diffuse;
}

#define FUR_LAYER(_FurLength) struct appdata\
{\
	float4 vertex : POSITION;\
	float2 uv1 : TEXCOORD0;\
	float3 normal : NORMAL;\
	float3 binoraml : BINORMAL;\
    float3 tangent : TANGENT;\
	ANI_ATTRIBUTE\
};\
struct v2f\
{\
    float4 vertex : SV_POSITION;\
	float4 uv : TEXCOORD0;\
    float3 worldPos : TEXCOORD1;\
	float3 worldnormal : TEXCOORD2;\
    float3 viewDirection : TEXCOORD3;\
    float3 lightDirection : TEXCOORD4;\
    float3 worldtangent : TEXCOORD5;\
    float3 worldbinormal : TEXCOORD6;\
};\
sampler2D _MainTex;\
sampler2D _FurTex;\
float4 _Gravity;\
float _GravityStrength;\
float _FurLength;\
float2 _UVOffset;\
float4 _OcclusionColor;\
float _FresnelLV;\
float _DirLightFilter;\
float _FurDirLightExposure;\
float _Thickness;\
float2 _MainTexOffset;\
float2 _MainTexTilling;\
float2 _FurTexOffset;\
float2 _FurTexTilling;

#define VERT_BASE(FURSTEP) v2f vert(appdata v)\
{\
    COMPUTE_BONE_MATERIX(v);\
	v2f o;\
    float furlen = _FurLength * 0.1 * FURSTEP;\
    float3 P = v.vertex.xyz + normalize(v.normal) * float3(furlen, furlen, furlen);\
    float4 vertex = float4(P.xyz, v.vertex.w);\
	float4 pos = ObjectToClipPos(vertex);\
	o.vertex = UniformNDC(pos);\
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;\
    o.worldPos = mul(LOCALWORLD_TRANSFORM, vertex).xyz;\
    o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;\
    o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;\
    o.uv = float4(TRANSFORM_TEX(v.uv1, _MainTexOffset, _MainTexTilling), TRANSFORM_TEX(v.uv1, _FurTexOffset, _FurTexTilling));\
    VIEW_DIRECTION(o, o.worldPos);\
    LIGHT_DIRECTION(o);\
	return o;\
}

#define VERT(FURSTEP) v2f vert(appdata v)\
{\
    COMPUTE_BONE_MATERIX(v);\
	v2f o;\
	o.worldnormal = ObjectToWorldNormal(v.normal).xyz;\
    o.worldPos = ObjectToWorldPos(v.vertex).xyz;\
    half3 direction = lerp(o.worldnormal, _Gravity * _GravityStrength + o.worldnormal * (1.0 - _GravityStrength), FURSTEP);\
	o.worldPos.xyz += direction * _FurLength * FURSTEP;\
    float4 expandPos = float4(o.worldPos.xyz, 1.0);\
	float4 pos = mul(CAMERA_VIEWPROJ, expandPos);\
	o.vertex = UniformNDC(pos);\
    o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;\
    o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;\
    float2 uvoffset = _UVOffset  * FURSTEP;\
    uvoffset *=  0.05 ; \
    float2 mainTexUV = TRANSFORM_TEX(v.uv1, _MainTexOffset, _MainTexTilling);\
    float2 noiseTexUV = TRANSFORM_TEX(v.uv1, _FurTexOffset, _FurTexTilling);\
    float2 uv1= mainTexUV.xy + uvoffset;\
    float2 uv2= noiseTexUV.xy + uvoffset;\
    o.uv = float4(uv1,uv2);\
    VIEW_DIRECTION(o, o.worldPos);\
    LIGHT_DIRECTION(o);\
	return o;\
}




#define FRAG_BASE(FURSTEP) float4 frag(v2f i) : SV_Target\
{\
	float4 mainColor = tex2D(_MainTex, i.uv.xy);\
    SSurface surface;\
    surface.uv = i.uv;\
    surface.worldPos = i.worldPos;\
    surface.worldnormal = i.worldnormal;\
    surface.worldtangent = i.worldtangent;\
    surface.worldbinormal = i.worldbinormal;\
    surface.viewDirection = i.viewDirection;\
    surface.lightDirection = i.lightDirection;\
    surface.furStep = FURSTEP;\
    surface.occlusionColor = _OcclusionColor.rgb;\
    surface.fresnelLV = _FresnelLV;\
    surface.furDirLightExposure = _FurDirLightExposure;\
    surface.dirLightFilter = _DirLightFilter;\
    float3 color = CalFurLight(surface);\
	return float4(mainColor.rgb * color.rgb, 1.0);\
}\

#define FRAG(FURSTEP) float4 frag(v2f i) : SV_Target\
{\
    fixed alpha = tex2D(_FurTex, i.uv.zw).r;\
	float4 mainColor = tex2D(_MainTex, i.uv.xy);\
    SSurface surface;\
    surface.uv = i.uv;\
    surface.worldPos = i.worldPos;\
    surface.worldnormal = i.worldnormal;\
    surface.worldtangent = i.worldtangent;\
    surface.worldbinormal = i.worldbinormal;\
    surface.viewDirection = i.viewDirection;\
    surface.lightDirection = i.lightDirection;\
    surface.furStep = FURSTEP;\
    surface.occlusionColor = _OcclusionColor.rgb;\
    surface.fresnelLV = _FresnelLV;\
    surface.furDirLightExposure = _FurDirLightExposure;\
    surface.dirLightFilter = _DirLightFilter;\
    float3 color = CalFurLight(surface);\
	return float4(mainColor.rgb * color.rgb, saturate(alpha - pow(FURSTEP, _Thickness)));\
}\

#endif