
#ifndef BLENDFUUNC_INC
#define BLENDFUUNC_INC
//暂时只提供：Normal,Add,Lighten,Multiply,Overlay,Screen这几种叠加模式
  
//Normal
float3 blendNormal(float4 base, float4 blend) {
  float3 blendRGB = base.rgb * (1.0 - blend.a) + blend.rgb * blend.a;
	return blendRGB;
}

//Alpha混合提供的Opacity就不起作用了
float3 blendNormal(float4 base, float4 blend, float opacity) {
  //return blendNormal(base,blend);
	return (blendNormal(base, blend) * opacity + base.rgb * (1.0 - opacity));
}

//Add
float blendAdd(float base, float blend) {
	return min(base+blend,1.0);
}

float3 blendAdd(float4 base, float4 blend) {
	return min(base.rgb + blend.rgb,float3(1.0,1.0,1.0));
}

float3 blendAdd(float4 base, float4 blend, float opacity) {
	return (blendAdd(base, blend) * opacity + base.rgb * (1.0 - opacity));
}

//Overlay
float blendOverlay(float base, float blend) {
	return base<0.5?(2.0*base*blend):(1.0-2.0*(1.0-base)*(1.0-blend));
}

float3 blendOverlay(float4 base, float4 blend) {
	return float3(blendOverlay(base.r,blend.r),blendOverlay(base.g,blend.g),blendOverlay(base.b,blend.b));
}

float3 blendOverlay(float4 base, float4 blend, float opacity) {
	return (blendOverlay(base, blend) * opacity + base.rgb * (1.0 - opacity));
}

//Multiply
float3 blendMultiply(float4 base, float4 blend) {
  return base.rgb * blend.rgb;
	//return base*blend;
}

float3 blendMultiply(float4 base, float4 blend, float opacity) {
	return (blendMultiply(base, blend) * opacity + base.rgb * (1.0 - opacity));
}

//Lighten
float blendLighten(float base, float blend) {
	return max(blend,base);
}

float3 blendLighten(float4 base, float4 blend) {
	return float3(blendLighten(base.r,blend.r),blendLighten(base.g,blend.g),blendLighten(base.b,blend.b));
}

float3 blendLighten(float4 base, float4 blend, float opacity) {
	return (blendLighten(base, blend) * opacity + base.rgb * (1.0 - opacity));
}

//Screen
float blendScreen(float base, float blend) {
	return 1.0-((1.0-base)*(1.0-blend));
}

float3 blendScreen(float4 base, float4 blend) {
	return float3(blendScreen(base.r,blend.r),blendScreen(base.g,blend.g),blendScreen(base.b,blend.b));
}

float3 blendScreen(float4 base, float4 blend, float opacity) {
	return (blendScreen(base, blend) * opacity + base.rgb * (1.0 - opacity));
}
//Lihgter Color
float3 blendLighter(float4 base, float4 blend) {
	if((base.r + base.g + base.b) > (blend.r + blend.g + blend.b))
		return base.rgb;
	else
		return blend.rgb;
}

float3 blendLighter(float4 base, float4 blend, float opacity)
{
	return (blendLighter(base,blend) * opacity + base.rgb * (1.0 - opacity));
}



float3 blend( int mode, float4 base, float4 blend ){
  if( mode == 1 ){
    return blendNormal(base,blend);
  }else
	if( mode == 2 ){
		return blendAdd( base, blend );
	}else
	if( mode == 3 ){
		return blendLighten( base, blend );
	}else
	if( mode == 4 ){
		return blendMultiply( base, blend );
	}else
	if( mode == 5 ){
		return blendOverlay( base, blend );
	}else
	if( mode == 6 ){
		return blendScreen( base, blend );
	}else
	if (mode == 7) {
		return blendLighter(base,blend);
	}
  return float3(1.0,0.0,0.0);
}

float3 blend( int mode, float4 base, float4 blend, float opacity ){
  if( mode == 1 ){
    return blendNormal(base,blend,opacity);
  }else
	if( mode == 2 ){
		return blendAdd( base, blend,opacity );
	}else
	if( mode == 3 ){
		return blendLighten( base, blend ,opacity);
	}else
	if( mode == 4 ){
		return blendMultiply( base, blend,opacity );
	}else
	if( mode == 5 ){
		return blendOverlay( base, blend,opacity );
	}else
	if( mode == 6 ){
		return blendScreen( base, blend,opacity );
	}else
	if( mode == 7) {
		return blendLighter(base,blend,opacity);
	}
  return float3(1.0,0.0,0.0);
}
#endif