

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
AMOUNT = { "Amount", FLOAT, "5.0"},
COMPLEXITY = { "Complexity", FLOAT, "5.0"},
SIZE = { "Size", FLOAT, "1.0"},
OFFSET = { "Offset", VEC2, "0.0,0.0"},
EVOLUTION = { "Evolution", FLOAT, "0.0"},

POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},

	}
	Attributes = 
	{
		POST_EFFECT_ALPHA = "Keywords(POST_EFFECT_ALPHA_ON,POST_EFFECT_ALPHA_OFF)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "turbulentdisplace"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"POST_EFFECT_ALPHA_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMOUNT",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COMPLEXITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIZE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OFFSET",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EVOLUTION",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_1 * _glesVertex);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float AMOUNT;
uniform highp float COMPLEXITY;
uniform highp float SIZE;
uniform highp vec2 OFFSET;
uniform highp float EVOLUTION;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 texColor_1;
  highp vec2 p_2;
  highp float frequency_3;
  frequency_3 = AMOUNT;
  highp float amplitude_4;
  amplitude_4 = SIZE;
  highp float a_6;
  highp float f_7;
  f_7 = 0.0;
  p_2 = (xlv_TEXCOORD0 * 2.0);
  a_6 = 1.0;
  for (highp int i_5 = 0; i_5 < 3; i_5++) {
    highp vec2 tmpvar_8;
    highp float tmpvar_9;
    tmpvar_9 = (EVOLUTION / 180.0);
    tmpvar_8.x = cos((tmpvar_9 * 3.141593));
    tmpvar_8.y = sin((tmpvar_9 * 3.141593));
    highp vec2 P_10;
    P_10 = (((
      (p_2 + OFFSET)
     + tmpvar_8) * frequency_3) * COMPLEXITY);
    highp vec4 grad_results_11;
    highp vec2 tmpvar_12;
    tmpvar_12 = floor(P_10);
    highp vec4 tmpvar_13;
    tmpvar_13.xy = tmpvar_12;
    tmpvar_13.zw = (tmpvar_12 + 1.0);
    highp vec4 tmpvar_14;
    tmpvar_14 = (P_10.xyxy - tmpvar_13);
    highp vec4 P_15;
    highp vec4 tmpvar_16;
    tmpvar_16.xy = tmpvar_12;
    tmpvar_16.zw = (tmpvar_12 + 1.0);
    P_15 = (tmpvar_16 - (floor(
      (tmpvar_16 * 0.01408451)
    ) * 71.0));
    P_15 = (P_15 + vec4(26.0, 161.0, 26.0, 161.0));
    P_15 = (P_15 * P_15);
    P_15 = (P_15.xzxz * P_15.yyww);
    highp vec4 tmpvar_17;
    tmpvar_17 = (fract((P_15 * 0.001051375)) - 0.49999);
    highp vec4 tmpvar_18;
    tmpvar_18 = (fract((P_15 * 0.001555331)) - 0.49999);
    grad_results_11 = ((inversesqrt(
      ((tmpvar_17 * tmpvar_17) + (tmpvar_18 * tmpvar_18))
    ) * (
      (tmpvar_17 * tmpvar_14.xzxz)
     + 
      (tmpvar_18 * tmpvar_14.yyww)
    )) * 1.414214);
    highp vec2 tmpvar_19;
    tmpvar_19 = (((tmpvar_14.xy * tmpvar_14.xy) * tmpvar_14.xy) * ((tmpvar_14.xy * 
      ((tmpvar_14.xy * 6.0) - 15.0)
    ) + 10.0));
    highp vec2 tmpvar_20;
    tmpvar_20 = mix (grad_results_11.xy, grad_results_11.zw, tmpvar_19.yy);
    f_7 = (f_7 + (a_6 * (
      mix (tmpvar_20.x, tmpvar_20.y, tmpvar_19.x)
     * amplitude_4)));
    p_2 = (2.0 * p_2);
    a_6 = (a_6 / 2.0);
  };
  lowp vec4 tmpvar_21;
  highp vec2 P_22;
  P_22 = (xlv_TEXCOORD0 + vec2(f_7));
  tmpvar_21 = texture2D (TEXTURE_DIFFUSE, P_22);
  texColor_1 = tmpvar_21;
  gl_FragData[0] = texColor_1;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"POST_EFFECT_ALPHA_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "AMOUNT",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COMPLEXITY",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "SIZE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OFFSET",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EVOLUTION",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_1 * _glesVertex);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float AMOUNT;
uniform highp float COMPLEXITY;
uniform highp float SIZE;
uniform highp vec2 OFFSET;
uniform highp float EVOLUTION;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 texColor_1;
  highp vec2 p_2;
  highp float frequency_3;
  frequency_3 = AMOUNT;
  highp float amplitude_4;
  amplitude_4 = SIZE;
  highp float a_6;
  highp float f_7;
  f_7 = 0.0;
  p_2 = (xlv_TEXCOORD0 * 2.0);
  a_6 = 1.0;
  for (highp int i_5 = 0; i_5 < 3; i_5++) {
    highp vec2 tmpvar_8;
    highp float tmpvar_9;
    tmpvar_9 = (EVOLUTION / 180.0);
    tmpvar_8.x = cos((tmpvar_9 * 3.141593));
    tmpvar_8.y = sin((tmpvar_9 * 3.141593));
    highp vec2 P_10;
    P_10 = (((
      (p_2 + OFFSET)
     + tmpvar_8) * frequency_3) * COMPLEXITY);
    highp vec4 grad_results_11;
    highp vec2 tmpvar_12;
    tmpvar_12 = floor(P_10);
    highp vec4 tmpvar_13;
    tmpvar_13.xy = tmpvar_12;
    tmpvar_13.zw = (tmpvar_12 + 1.0);
    highp vec4 tmpvar_14;
    tmpvar_14 = (P_10.xyxy - tmpvar_13);
    highp vec4 P_15;
    highp vec4 tmpvar_16;
    tmpvar_16.xy = tmpvar_12;
    tmpvar_16.zw = (tmpvar_12 + 1.0);
    P_15 = (tmpvar_16 - (floor(
      (tmpvar_16 * 0.01408451)
    ) * 71.0));
    P_15 = (P_15 + vec4(26.0, 161.0, 26.0, 161.0));
    P_15 = (P_15 * P_15);
    P_15 = (P_15.xzxz * P_15.yyww);
    highp vec4 tmpvar_17;
    tmpvar_17 = (fract((P_15 * 0.001051375)) - 0.49999);
    highp vec4 tmpvar_18;
    tmpvar_18 = (fract((P_15 * 0.001555331)) - 0.49999);
    grad_results_11 = ((inversesqrt(
      ((tmpvar_17 * tmpvar_17) + (tmpvar_18 * tmpvar_18))
    ) * (
      (tmpvar_17 * tmpvar_14.xzxz)
     + 
      (tmpvar_18 * tmpvar_14.yyww)
    )) * 1.414214);
    highp vec2 tmpvar_19;
    tmpvar_19 = (((tmpvar_14.xy * tmpvar_14.xy) * tmpvar_14.xy) * ((tmpvar_14.xy * 
      ((tmpvar_14.xy * 6.0) - 15.0)
    ) + 10.0));
    highp vec2 tmpvar_20;
    tmpvar_20 = mix (grad_results_11.xy, grad_results_11.zw, tmpvar_19.yy);
    f_7 = (f_7 + (a_6 * (
      mix (tmpvar_20.x, tmpvar_20.y, tmpvar_19.x)
     * amplitude_4)));
    p_2 = (2.0 * p_2);
    a_6 = (a_6 / 2.0);
  };
  lowp vec4 tmpvar_21;
  highp vec2 P_22;
  P_22 = (xlv_TEXCOORD0 + vec2(f_7));
  tmpvar_21 = texture2D (TEXTURE_DIFFUSE, P_22);
  texColor_1 = tmpvar_21;
  highp vec4 tmpvar_23;
  tmpvar_23.w = 1.0;
  tmpvar_23.xyz = texColor_1.xyz;
  gl_FragData[0] = tmpvar_23;
}

]===],
	},
}

end
