

function DefineParams()
	Properties = 
	{
		
COLOR_DARK = { "colorDark", VEC3, "255, 0, 0"},
COLOR_MIDDLE = { "colorMiddle", VEC3, "0, 255, 0"},
COLOR_LIGHT = { "colorLight", VEC3, "0, 0, 255"},
BLEND_FACTOR = { "blendFactor", FLOAT, "100"},

POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},

	}
	Attributes = 
	{
		POST_EFFECT_ALPHA = "Keywords(POST_EFFECT_ALPHA_ON,POST_EFFECT_ALPHA_OFF)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "tunes"
RenderQueue = "PostEffect"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"POST_EFFECT_ALPHA_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_DARK",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_MIDDLE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_LIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BLEND_FACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 COLOR_DARK;
uniform highp vec3 COLOR_MIDDLE;
uniform highp vec3 COLOR_LIGHT;
uniform highp float BLEND_FACTOR;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 originColor_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  originColor_1 = tmpvar_2;
  highp float tmpvar_3;
  tmpvar_3 = (((0.2989 * originColor_1.x) + (0.587 * originColor_1.y)) + (0.114 * originColor_1.z));
  highp float tmpvar_4;
  tmpvar_4 = ((cos(
    (6.283186 * tmpvar_3)
  ) * 0.5) + 0.5);
  bool tmpvar_5;
  tmpvar_5 = (tmpvar_3 < 0.5);
  highp float tmpvar_6;
  if (tmpvar_5) {
    tmpvar_6 = tmpvar_4;
  } else {
    tmpvar_6 = 0.0;
  };
  highp float tmpvar_7;
  if (tmpvar_5) {
    tmpvar_7 = 0.0;
  } else {
    tmpvar_7 = tmpvar_4;
  };
  highp vec4 tmpvar_8;
  tmpvar_8.xyz = clamp (((originColor_1.xyz * BLEND_FACTOR) + (
    clamp ((((COLOR_DARK * tmpvar_6) + (COLOR_MIDDLE * 
      (1.0 - tmpvar_4)
    )) + (COLOR_LIGHT * tmpvar_7)), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   * 
    (1.0 - BLEND_FACTOR)
  )), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  tmpvar_8.w = originColor_1.w;
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"POST_EFFECT_ALPHA_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_DARK",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_MIDDLE",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COLOR_LIGHT",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "BLEND_FACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D TEXTURE_DIFFUSE;
uniform highp vec3 COLOR_DARK;
uniform highp vec3 COLOR_MIDDLE;
uniform highp vec3 COLOR_LIGHT;
uniform highp float BLEND_FACTOR;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 originColor_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  originColor_1 = tmpvar_2;
  highp float tmpvar_3;
  tmpvar_3 = (((0.2989 * originColor_1.x) + (0.587 * originColor_1.y)) + (0.114 * originColor_1.z));
  highp float tmpvar_4;
  tmpvar_4 = ((cos(
    (6.283186 * tmpvar_3)
  ) * 0.5) + 0.5);
  bool tmpvar_5;
  tmpvar_5 = (tmpvar_3 < 0.5);
  highp float tmpvar_6;
  if (tmpvar_5) {
    tmpvar_6 = tmpvar_4;
  } else {
    tmpvar_6 = 0.0;
  };
  highp float tmpvar_7;
  if (tmpvar_5) {
    tmpvar_7 = 0.0;
  } else {
    tmpvar_7 = tmpvar_4;
  };
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.xyz = clamp (((originColor_1.xyz * BLEND_FACTOR) + (
    clamp ((((COLOR_DARK * tmpvar_6) + (COLOR_MIDDLE * 
      (1.0 - tmpvar_4)
    )) + (COLOR_LIGHT * tmpvar_7)), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0))
   * 
    (1.0 - BLEND_FACTOR)
  )), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0));
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
}

end
