
function DefineParams()
	Properties = 
	{
		
EDGE_WIDTH = { "EDGE_WIDTH", FLOAT, "1.0" },
OFFSET_SCALE = { "OFFSET_SCALE", FLOAT, "1.0" },
MIN_WIDTH = { "MIN_WIDTH", FLOAT, "1.0" },
RANGE_DISTANCE = { "RANGE_DISTANCE", FLOAT, "1.0" },
Main_Color = { "Main_Color", VEC2, "1.0,1.0,1.0,1.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "simpleoutline"
RenderQueue = "Opaque"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_FRONT, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EDGE_WIDTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OFFSET_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MIN_WIDTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RANGE_DISTANCE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "Main_Color",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec3 _glesNormal;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float EDGE_WIDTH;
uniform highp float OFFSET_SCALE;
uniform highp float MIN_WIDTH;
uniform highp float RANGE_DISTANCE;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp float zcof_2;
  highp vec4 projSpaceNormal_3;
  highp vec4 out_Position_4;
  highp vec4 tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.w = 1.0;
  tmpvar_6.xyz = tmpvar_1.xyz;
  tmpvar_5 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_6));
  out_Position_4 = tmpvar_5;
  highp mat3 tmpvar_7;
  tmpvar_7[uint(0)] = LOCALWORLD_TRANSFORM[uint(0)].xyz;
  tmpvar_7[1u] = LOCALWORLD_TRANSFORM[1u].xyz;
  tmpvar_7[2u] = LOCALWORLD_TRANSFORM[2u].xyz;
  highp vec4 tmpvar_8;
  tmpvar_8.w = 0.0;
  tmpvar_8.xyz = normalize((tmpvar_7 * _glesNormal));
  highp vec4 tmpvar_9;
  tmpvar_9 = (CAMERA_VIEWPROJ * tmpvar_8);
  projSpaceNormal_3.zw = tmpvar_9.zw;
  projSpaceNormal_3.xy = normalize(tmpvar_9.xy);
  highp vec4 tmpvar_10;
  highp vec4 tmpvar_11;
  tmpvar_11.w = 1.0;
  tmpvar_11.xyz = tmpvar_1.xyz;
  tmpvar_10 = (LOCALWORLD_TRANSFORM * tmpvar_11);
  highp float tmpvar_12;
  tmpvar_12 = abs(tmpvar_10.z);
  zcof_2 = tmpvar_12;
  if ((tmpvar_12 > RANGE_DISTANCE)) {
    zcof_2 = RANGE_DISTANCE;
  };
  zcof_2 = (zcof_2 / RANGE_DISTANCE);
  zcof_2 = (1.0 - zcof_2);
  highp float tmpvar_13;
  tmpvar_13 = (MIN_WIDTH / EDGE_WIDTH);
  if ((zcof_2 < tmpvar_13)) {
    zcof_2 = tmpvar_13;
  };
  highp float tmpvar_14;
  tmpvar_14 = min (1.0, zcof_2);
  zcof_2 = tmpvar_14;
  out_Position_4.xy = (tmpvar_5.xy + ((
    ((0.004275 * projSpaceNormal_3) * abs(tmpvar_10.z))
   * tmpvar_14) * EDGE_WIDTH).xy);
  out_Position_4.z = (tmpvar_5.z + (6e-5 * OFFSET_SCALE));
  highp vec4 tmpvar_15;
  tmpvar_15.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_15.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_15 * out_Position_4);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp vec4 Main_Color;
void main ()
{
  _glesFragData[0] = Main_Color;
}

]===],
	},
}

end
