#SHADER_DEFINE TunesVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE TunesFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
        { COLOR_DARK,          MEDIUM,    VEC3,        "in_colorDark" },
        { COLOR_MIDDLE,        MEDIUM,    VEC3,        "in_colorMiddle" },
        { COLOR_LIGHT,         MEDIUM,    VEC3,        "in_colorLight" },
        { BLEND_FACTOR,        MEDIUM,    FLOAT,       "in_blend" },
    }

#SHADER_CODE

    const highp float pi = 3.14159265359;

    vec4 originColor = texture2D(in_DiffuseTexture, in_TexCoordinate);
    highp float luma = 0.2989 * originColor.r + 0.5870 * originColor.g + 0.1140 * originColor.b;

    float factorCos = cos(luma * 2.0 * pi) * 0.5 + 0.5;
    bool beingDark = luma < 0.5;
    float factorDark = beingDark ? factorCos : 0.0;
    float factorLight = beingDark ? 0.0 : factorCos;
    float factorMiddle = 1.0 - factorCos;

    vec3 colorTunes = in_colorDark * factorDark + in_colorMiddle * factorMiddle + in_colorLight * factorLight;
    colorTunes = clamp(colorTunes, 0.0, 1.0);
    vec3 colorMix = originColor.rgb * in_blend + colorTunes * (1.0 - in_blend);
    colorMix = clamp(colorMix, 0.0, 1.0);
    
    gl_FragColor = vec4(colorMix, 1.0);

#END_CODE
#END_DEFINE







