#include "functions/rgb_hsv.function"

#SHADER_DEFINE HSLADJVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE HSLADJFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
        { HSLADJ_HUE,                MEDIUM,    FLOAT,       "in_hue" },
        { HSLADJ_SAT,                MEDIUM,    FLOAT,       "in_sat" },
        { HSLADJ_LUM,                MEDIUM,    FLOAT,       "in_lum" },
    }

#SHADER_CODE

    highp vec3 rgb = texture2D(in_DiffuseTexture, in_TexCoordinate).rgb;
    highp vec3 hsl = hsv2hsl(rgb2hsv(rgb));
    highp float e = 1.0e-10;
    hsl.x = fract(hsl.x + in_hue + 1.0);
    if (in_sat >= 0.0) {
        hsl.y = 1.0 - in_sat <= e ? 1.0 : clamp(hsl.y / (1.0 - in_sat), 0.0, 1.0);
    } else {
        hsl.y = clamp(hsl.y * (1.0 + in_sat), 0.0, 1.0);
    }
    hsl.z = clamp(hsl.z + (1.0 - hsl.z) * in_lum, 0.0, 1.0);
    rgb = hsv2rgb(hsl2hsv(hsl));
    gl_FragColor = vec4(rgb, 1.0);

#END_CODE
#END_DEFINE







