//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////

// 输出纹理坐标 等于 输入纹理坐标
#SHADER_DEFINE Base2DCoordinate
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "in_Coordinate" },
    }

    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "Out_Coordinate" },
    }
#SHADER_CODE
    mediump vec2 Out_Coordinate = in_Coordinate;
#END_CODE
#END_DEFINE


//输出在世界空间下的顶点属性
//输出两个变换矩阵
#SHADER_DEFINE TransfromWorldPosition
    FUNCTION_INPUT =
    {
        { CAMERA_VIEWPROJ,						HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },
        { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_NORMAL,						HIGH,    VEC3,        "in_Normal" },
				{	ATTRIBUTE_TANGENT,					HIGH,    VEC3,        "in_Tangent"},
    }
    FUNCTION_OUTPUT =
    {
        { SCREENSPACE_POSITION,     	HIGH,	VEC4,        "out_Position" },
		{ WORLDSPACE_POSITION,        	HIGH,	VEC3,        "out_PositionWS" },
        { WORLDSPACE_NORMAL,         	HIGH,	VEC3,        "out_NormalWS" },
		{ WORLDSPACE_TANGENT,   		HIGH,	VEC3,    	"out_TangentWS"},
		{ WORLDSPACE_BINORMAL,  		HIGH, 	VEC3,    	"out_BiTangentWS"},
		{	W2T_TBN_MAT,										HIGH,   MAT3,         "W2T_TBN"},
		{	T2W_TBN_MAT,										HIGH,   MAT3,         "T2W_TBN"},

    }
#SHADER_CODE
		vec4 out_Position = in_ViewPorj * in_Transfrom * in_Position;

		vec3 out_PositionWS  = vec3(in_Transfrom * in_Position);
		vec3 out_NormalWS = normalize(in_WorldRotation * in_Normal);
		vec3 out_TangentWS =  normalize(in_WorldRotation * in_Tangent);
		vec3 out_BiTangentWS = normalize(cross(out_TangentWS, out_NormalWS));
		mat3 T2W_TBN = mat3(out_TangentWS,out_BiTangentWS,out_NormalWS);//从切线空间转到世界空间的矩阵
		mat3 W2T_TBN = mat3(
		vec3(out_TangentWS.x,out_BiTangentWS.x,out_NormalWS.x),
		vec3(out_TangentWS.y,out_BiTangentWS.y,out_NormalWS.y),
		vec3(out_TangentWS.z,out_BiTangentWS.z,out_NormalWS.z));//从世界空间转到切线空间的矩阵

#END_CODE
#END_DEFINE


// 平行光源的ViewDir的输出，将平行光的方向转换到切线空间下
#SHADER_DEFINE DirectionLightVertex

	FUNCTION_INPUT =
	{
		{	W2T_TBN_MAT,										HIGH,   MAT3,         "W2T_TBN"},
		{ CAMERA_WORLDPOSITION,		HIGH,	VEC3,	"in_CameraPosition" },
		{ WORLDSPACE_POSITION,		HIGH,	VEC4,	"in_PositionWS" },
		{ LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"in_LightDirection" },
	}

	FUNCTION_OUTPUT =
	{
		{ 	WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,					"out_WorldViewDirection" },
		{	TANGENTSPACE_VIEWDIRECTION,				LOW,			VEC3,					"out_ViewDirection"},
		{	TANGENTSPACE_LIGHTDIRECTION,			LOW,			VEC3,					"out_LightDirection"},
		{ 		LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"out_WorldLightDirection" }
	}

#SHADER_CODE
	vec3 out_WorldViewDirection = normalize(in_CameraPosition - in_PositionWS);
	vec3 out_ViewDirection =  normalize(W2T_TBN*(in_CameraPosition - in_PositionWS));
	vec3 out_LightDirection = normalize(W2T_TBN*in_LightDirection);
	vec3 out_WorldLightDirection = normalize(in_LightDirection);
#END_CODE
#END_DEFINE


// 顶点的坐标等于屏幕空间下的位置
#SHADER_DEFINE VertexOutput
    FUNCTION_INPUT =
    {
        { SCREENSPACE_POSITION,        HIGH,    VEC4,    "in_ScreenPosition" },
    }
    FUNCTION_OUTPUT = { }
#SHADER_CODE
    gl_Position = in_ScreenPosition;
#END_CODE
#END_DEFINE
