//#define mlaa_estepvalue 0.9
//#define mlaa_texstepval 1.0
//#define mlaa_texoffsetval 1.0
//#define mlaa_e_scale      0.0


static float mlaa_estepvalue=0.9;
static float mlaa_texstepval=2.0;
static float mlaa_texoffsetval=1.5;
static float mlaa_e_scale    = 1.0;
static float mlaa_searchsteps= 4.0;


float2 round_ml(float2 v2in)
{

  float2 v = float2(float(int(v2in.x+0.5)),float(int(v2in.y+0.5)));
  return v;
}

float encodegamma(float val)
{

 return pow(val,1.0/2.0);

}


float decodegamma(float val)
{
  return pow(val,2.0);
}

float3 encodegamma(float3 val)
{
  
  //return float3(encodegamma(val.x),encodegamma(val.y),encodegamma(val.z));
  return pow(val,float3(1.0/2.0,1.0/2.0,1.0/2.0));
   
}

float3 decodegamma(float3 val)
{
  
  // return  float3(decodegamma(val.x),decodegamma(val.y),decodegamma(val.z));
    return pow(val,float3(2.0,2.0,2.0));
}

float2 encodegamma(float2 val)
{
  
  return pow(val,float2(1.0/2.0,1.0/2.0));
   
}

float2 decodegamma(float2 val)
{
  
  return pow(val,float2(2.0,2.0));
}

float4 decodegamma(float4 val)
{
  return pow(val,float4(2.0,2.0,2.0,2.0));
}

float4 encodegamma(float4 val)
{
  return pow(val,float4(1.0/2.0,1.0/2.0,1.0/2.0,1.0/2.0));
   
}





float SearchXLeft(float2 texcoordIn, sampler2D in_tex,float2 pixelsize,int searchsteps)
{
    float2 texcoord = texcoordIn;
    float2 _pixelsz = pixelsize;
    int maxSearchSteps = searchsteps;
     float texstepval = mlaa_texstepval;
     float texoffsetval =mlaa_texoffsetval;
    texcoord =texcoord- float2(texoffsetval, 0.0) * _pixelsz;
    float e = 0.0;
    int i =int(0.0);
     
    for (i; i < maxSearchSteps; i++)
    {
       // e = edgesTex.SampleLevel(LinearSampler, texcoord, 0).g;
       e =tex2D(in_tex,texcoord).g;
       if (e < mlaa_estepvalue) break;
          texcoord = texcoord-float2(texstepval, 0.0) * _pixelsz;
    }
  
  //return 0.0;
   return max(-texstepval * float(i) - texstepval * e*mlaa_e_scale, -texstepval * float(maxSearchSteps));
}


float SearchXRight(float2 texcoordIn,sampler2D in_tex,float2 pixelsize,int searchsteps)
{

    float2 texcoord = texcoordIn;
    float2 _pixelsz = pixelsize;
    float e = 0.0;
    int i =int(0.0);
    int maxSearchSteps = searchsteps;
    float texstepval = mlaa_texstepval;
        float texoffsetval = mlaa_texoffsetval;
    texcoord = texcoord + float2(texoffsetval, 0.0) * _pixelsz;
     
    for (i ; i < maxSearchSteps; i++) 
    {
        //e = edgesTex.SampleLevel(LinearSampler, texcoord, 0).g;
        e =tex2D(in_tex,texcoord).g;
        if (e < mlaa_estepvalue) break;
        texcoord = texcoord+float2(texstepval, 0.0) * _pixelsz;
    }
    return min(texstepval * float(i) + texstepval * e*mlaa_e_scale, texstepval * float(maxSearchSteps));
}


float2 Area(float2 distance, float e1, float e2,float maxdis,sampler2D areaTex )
{
  float MAX_DISTANCE = maxdis;
  float areaSize = MAX_DISTANCE * 5.0;
  float2 pixcoord = MAX_DISTANCE * round_ml(4.0 * float2(e1, e2)) + distance;
  float2 texcoord = pixcoord / (areaSize - 1.0);
  //return float2(encodegamma(tex2D(areaTex,texcoord).r),encodegamma(tex2D(areaTex,texcoord).g));
  return tex2D(areaTex,texcoord).rg;
}







float  SearchYUp(float2 texcoord,sampler2D in_tex,float2 pixelsize,int searchsteps)
{
    float2 _pixelsz = pixelsize;
    float e = 0.0;
    int i =int(0.0);
    int maxSearchSteps = searchsteps;
    
    texcoord = texcoord -float2(0.0, 1.5) * _pixelsz;
     
    for ( i; i < maxSearchSteps; i++) 
    {
       e =tex2D(in_tex,texcoord).r;
       if (e < mlaa_estepvalue) 
       break;
       texcoord = texcoord-float2(0.0, 2.0) * _pixelsz;
    }
    return max(-2.0 * float(i) - 2.0 * e, -2.0 * float(maxSearchSteps));
}


float  SearchYUp2(float2 texcoord,sampler2D in_tex,float2 pixelsize,int searchsteps)
{
    float2 _pixelsz = pixelsize;
    float e = 0.0;
    int i =int(0.0);
       float texoffsetval = mlaa_texoffsetval;
    int maxSearchSteps = searchsteps;
    float texstepval = mlaa_texstepval;
    texcoord = texcoord + float2(0.0, texoffsetval) * _pixelsz;
    
    for ( i; i < maxSearchSteps; i++) 
    {
       e =tex2D(in_tex,texcoord).r;
       if (e < mlaa_estepvalue) 
       break;
       texcoord = texcoord+float2(0.0, texstepval) * _pixelsz;
    }
    return max(-texstepval * float(i) - texstepval * e*mlaa_e_scale, -texstepval * float(maxSearchSteps));
}


float SearchYDown2(float2 texcoord,sampler2D in_tex,float2 pixelsize,int searchsteps)
{
    float2 _pixelsz = pixelsize;
    int i =int(0.0);
    int maxSearchSteps = searchsteps;
     float texstepval = mlaa_texstepval;
    float texoffsetval = mlaa_texoffsetval;
    texcoord = texcoord -float2(0.0, texoffsetval) * _pixelsz;
    float e = 0.0;
     
    for ( i ; i < maxSearchSteps; i++) 
    {
        e =tex2D(in_tex,texcoord).r;
        if (e < mlaa_estepvalue) break;
        texcoord = texcoord-float2(0.0, texstepval) * _pixelsz;
    }
    return min(texstepval * float(i) + texstepval * e*mlaa_e_scale,texstepval * float(maxSearchSteps));
}

float SearchYDown(float2 texcoord,sampler2D in_tex,float2 pixelsize,int searchsteps)
{
    float2 _pixelsz = pixelsize;
    int i =int(0.0);
    int maxSearchSteps = searchsteps;
    texcoord = texcoord +float2(0.0, 1.5) * _pixelsz;
    float e = 0.0;
     
    for ( i ; i < maxSearchSteps; i++)
    {
        e =tex2D(in_tex,texcoord).r;
        if (e < 0.9) break;
        texcoord = texcoord+float2(0.0, 2.0) * _pixelsz;
    }
    return min(2.0 * float(i) + 2.0 * e, 2.0 * float(maxSearchSteps));
}

float4 mad(float4 m, float4 a, float4 b)
{
    return m * a + b;
}