//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////





#SHADER_DEFINE EmitterSize

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_EMITTER_OFFSET,			MEDIUM,	VEC2,		"in_Offset" },
    { ATTRIBUTE_EMITTER_SIZE, MEDIUM, FLOAT, "in_EmitterSize" },
	}

	FUNCTION_OUTPUT = 
	{
		{ PARTICLE_OFFEET,		MEDIUM,	VEC2,	"out_Offset" },
	}

#SHADER_CODE
  vec2 out_Offset = in_Offset * in_EmitterSize;
#END_CODE
#END_DEFINE


#SHADER_DEFINE BezierCurveSize

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_EMITTER_LIFE,	HIGH,	FLOAT,	"in_Life" },
		{ EMITTER_AGE,				    HIGH,	FLOAT,	"in_Age" },
    { ATTRIBUTE_EMITTER_OFFSET,			MEDIUM,	VEC2,		"in_Offset" },
    { ATTRIBUTE_EMITTER_SIZE, MEDIUM, FLOAT, "in_EmitterSize" },
    { PARTICLE_STRETCH,         MEDIUM, MAT3,  "in_Stretch" },
    { BEZIER_SIZE_ONE,       LOW,  FLOAT,   "in_control_size_1"},
    { BEZIER_SIZE_TWO,       LOW,  FLOAT,   "in_control_size_2"},
    { BEZIER_SIZE_THREE,       LOW,  FLOAT,   "in_control_size_3"},
    { BEZIER_SIZE_FOUR,       LOW,  FLOAT,   "in_control_size_4"},
	}

	FUNCTION_OUTPUT = 
	{
    { PARTICLE_OFFEET,		MEDIUM,	VEC2,	"out_Offset" },
	}
	
#SHADER_CODE
    float in_ControlSize1 = in_control_size_1;
    float in_ControlSize2 = in_control_size_2;
    float in_ControlSize3 = in_control_size_3;
    float in_ControlSize4 = in_control_size_4;
  
    float st = in_Age / in_Life;
    float st2 = st * st;
    float one_minus_st = 1.0 - st;
    float one_minus_st2 = one_minus_st * one_minus_st;
    float emittersize = in_ControlSize1 * one_minus_st2 * one_minus_st + in_ControlSize2 * 3.0 * st * one_minus_st2 + in_ControlSize3 * 3.0 * st2 * one_minus_st + in_ControlSize4 * st2 * st;
    emittersize = emittersize * in_EmitterSize;
    
    vec2 out_Offset = in_Offset * emittersize;
    float stretch_ratio = in_Stretch[2][0];
    mat2 stretchrotation = mat2(in_Stretch[0][0],in_Stretch[0][1],in_Stretch[1][0],in_Stretch[1][1]);
    vec2 offsetVec2 = out_Offset;
    offsetVec2.x *= stretch_ratio;
    offsetVec2 = offsetVec2 * stretchrotation;
    out_Offset = offsetVec2;
#END_CODE
#END_DEFINE