

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "quadtexture"
RenderQueue = "Transparent"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA , SRC_ALPHA, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv1 : TEXCOORD0;
	float2 uv2 : TEXCOORD1;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};

sampler2D TEXTURE_DIFFUSE;

v2f vert(appdata v)
{
	v2f o;
	float4 pos = mul(mul(CAMERA_VIEW, LOCALWORLD_TRANSFORM), v.vertex);
	o.vertex.w = pos.w;
	float3 vert;
	vert.z = 0;
	vert.xy = v.uv2;
	o.vertex.xyz = pos.xyz + vert;
	o.vertex = mul(CAMERA_PROJECTION, o.vertex);
	o.vertex = UniformNDC(o.vertex);  
	o.uv = v.uv1.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{
	float4 col = tex2D(TEXTURE_DIFFUSE, i.uv);
    return col;
}
ENDCG
#END
