

#DEFPARAMS

#END

#DEFTAG
ShaderName = "OutlineExpand"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 TARGETSIZE;
float SIGMA;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float2 size = TARGETSIZE;
    float2 uv = i.uv;
    float twoSigma2 = 2.0 *SIGMA*SIGMA;
    float halfWidth = 2.0*SIGMA;
    float3 acum = tex2D(TEXTURE_DIFFUSE, uv ).rgb;
    float norm = 1.0;
    for ( float i = 1.0; i <= halfWidth; i++ )
    {
        float kern = exp( -(i*i)/ twoSigma2 );
        float3 loca = tex2D(TEXTURE_DIFFUSE, uv + float2(0.0,i) / size).rgb+tex2D(TEXTURE_DIFFUSE, uv + float2(0.0,-i) / size).rgb;
        norm += 2.0*kern;
        acum += kern * loca;
    }
    acum= acum/norm;
    float g = (acum.z*2.0-1.0) ;
    float phi=3.14159265358979323846264338327950288+ 0.5 * atan2(-2.0 * g, acum.y - acum.x);
    float4 finalColor = float4( 0.0,phi/(3.14159265358979323846264338327950288*2.0),(cos(phi)+1.0)*0.5 , (sin(phi)+1.0)*0.5);
    return finalColor;
}
ENDCG
#END
