

#DEFPARAMS

#END

#DEFTAG
ShaderName = "Combine_1"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_DIFFUSE2;
float2 TARGETSIZE;

float PRETHRESHOLD;
float THRESHOLD;
float SIGMA_R;
 
v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float tau=0.99;
    float sigma_e=1.0;
    float2 size = TARGETSIZE;
    float twoSigmaG1 = 2.0 * sigma_e * sigma_e;
    float twoSigmaG2 = 2.0 * SIGMA_R * SIGMA_R;
    float ancho = 2.0 * SIGMA_R;
    float2 uv = i.uv;
    float2 gradient = tex2D(TEXTURE_DIFFUSE, uv).zw;
    float2 dirPerpen = float2(gradient.y*2.0-1.0, -(gradient.x*2.0-1.0))/size;
    float2 acum = tex2D( TEXTURE_DIFFUSE2, uv ).xx;
    float2 norm = float2(1.0, 1.0);
    float4 finalColor;
    for( float i = 1.0; i <= ancho; i ++ )
    {
        float2 kernel = float2( exp( -i*i*i/ twoSigmaG1 ), exp( -i*i*i / twoSigmaG2 ));
        norm += 2.0* kernel;
        float local = tex2D( TEXTURE_DIFFUSE2, uv - i*dirPerpen ).x+tex2D( TEXTURE_DIFFUSE2, uv + i*dirPerpen ).x;
        acum += kernel*float2(local,local);
    }
    acum = acum/norm;
    float total = (300.0*PRETHRESHOLD) * (acum.x - tau * acum.y);
    finalColor = float4( (step (0.8, total ) ),gradient, 1.0);
    return finalColor;
}
ENDCG
#END
