

#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
TEXTURE_BLEND = { "tex blend", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "Simple"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 position : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 position : SV_POSITION;
	float2 uv : TEXCOORD0;
};

float3x3 LOCALWORLD_ROTATION;
sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_BLEND;

v2f vert(appdata v)
{
	v2f o;
	float4 positionWS = mul(LOCALWORLD_TRANSFORM, v.position);
	o.position = mul(CAMERA_VIEWPROJ, positionWS);
	o.position = UniformNDC(o.position);
	o.uv = v.uv;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float4 colorBlend = tex2D(TEXTURE_BLEND, i.uv);
	float4 color = tex2D(TEXTURE_DIFFUSE, i.uv);
	color.w = color.a * colorBlend.a;
	return color;
}
ENDCG
#END
