
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
TEXTURE_REFLECTION = { "reflection tex", TEXTURE2D, "white" },
UNIFORM_REFFACTOR = { "reffactor", FLOAT, "0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "nl_reflection"
RenderQueue = "Opaque"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_1);
  tmpvar_1 = tmpvar_11;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = tmpvar_11;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_1);
  tmpvar_1 = tmpvar_11;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = tmpvar_11;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_1);
  tmpvar_1 = tmpvar_11;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = tmpvar_11;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_1);
  tmpvar_1 = tmpvar_11;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = tmpvar_11;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_1);
  tmpvar_1 = tmpvar_11;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = tmpvar_11;
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"GPUSKIN4","DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ANIMATION_MATRIX_ARRAY",
				varType = "float4",
				varSit = "",
				varNum = "100",
				varRegIndex = "0",
				varRegCount = "100",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp vec4 ANIMATION_MATRIX_ARRAY[100];
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
attribute highp vec4 _glesBlendIndices;
attribute highp vec4 _glesBlendWeight;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  highp vec4 row2_2;
  highp vec4 row1_3;
  highp vec4 row0_4;
  highp int tmpvar_5;
  tmpvar_5 = (int(_glesBlendIndices.x) * 3);
  highp int tmpvar_6;
  tmpvar_6 = (int(_glesBlendIndices.y) * 3);
  highp int tmpvar_7;
  tmpvar_7 = (int(_glesBlendIndices.z) * 3);
  highp int tmpvar_8;
  tmpvar_8 = (int(_glesBlendIndices.w) * 3);
  row0_4 = (ANIMATION_MATRIX_ARRAY[tmpvar_5] * _glesBlendWeight.x);
  row1_3 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 1)] * _glesBlendWeight.x);
  row2_2 = (ANIMATION_MATRIX_ARRAY[(tmpvar_5 + 2)] * _glesBlendWeight.x);
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_6] * _glesBlendWeight.y));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 1)] * _glesBlendWeight.y));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_6 + 2)] * _glesBlendWeight.y));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_7] * _glesBlendWeight.z));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 1)] * _glesBlendWeight.z));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_7 + 2)] * _glesBlendWeight.z));
  row0_4 = (row0_4 + (ANIMATION_MATRIX_ARRAY[tmpvar_8] * _glesBlendWeight.w));
  row1_3 = (row1_3 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 1)] * _glesBlendWeight.w));
  row2_2 = (row2_2 + (ANIMATION_MATRIX_ARRAY[(tmpvar_8 + 2)] * _glesBlendWeight.w));
  highp mat4 tmpvar_9;
  tmpvar_9[0].x = row0_4.x;
  tmpvar_9[0].y = row0_4.y;
  tmpvar_9[0].z = row0_4.z;
  tmpvar_9[0].w = row0_4.w;
  tmpvar_9[1].x = row1_3.x;
  tmpvar_9[1].y = row1_3.y;
  tmpvar_9[1].z = row1_3.z;
  tmpvar_9[1].w = row1_3.w;
  tmpvar_9[2].x = row2_2.x;
  tmpvar_9[2].y = row2_2.y;
  tmpvar_9[2].z = row2_2.z;
  tmpvar_9[2].w = row2_2.w;
  tmpvar_9[3].x = 0.0;
  tmpvar_9[3].y = 0.0;
  tmpvar_9[3].z = 0.0;
  tmpvar_9[3].w = 1.0;
  tmpvar_1 = (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)));
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_11;
  tmpvar_11 = (tmpvar_10 * tmpvar_1);
  tmpvar_1 = tmpvar_11;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * (_glesVertex * tmpvar_9)).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = tmpvar_11;
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"NoLight"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOff"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF3x3","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF5x5","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_PCF7x7","SHADOWS_HARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#extension GL_EXT_shadow_samplers : enable
attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[#extension GL_EXT_shadow_samplers : enable
uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
	{
		shaderApi = "gles2",
		keyWords = {"DirLight","ShadowOn","SHADOW_ATTEN_NOHARDWARE"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "LOCALWORLD_TRANSFORM",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CAMERA_VIEWPROJ",
				varType = "float4x4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "LOCALWORLD_ROTATION",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "CAMERA_WORLDPOSITION",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_REFLECTION",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_REFFACTOR",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec3 _glesNormal;
attribute vec4 _glesMultiTexCoord0;
uniform highp mat4 LOCALWORLD_TRANSFORM;
uniform highp mat4 CAMERA_VIEWPROJ;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp mat3 LOCALWORLD_ROTATION;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec4 tmpvar_2;
  tmpvar_2.w = 1.0;
  tmpvar_2.xyz = tmpvar_1.xyz;
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_4;
  tmpvar_4.w = 1.0;
  tmpvar_4.xyz = tmpvar_1.xyz;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD2 = (LOCALWORLD_TRANSFORM * tmpvar_4).xyz;
  xlv_TEXCOORD3 = (LOCALWORLD_ROTATION * _glesNormal);
  gl_Position = (tmpvar_3 * (CAMERA_VIEWPROJ * (LOCALWORLD_TRANSFORM * tmpvar_2)));
}

]===],
		psShader = [===[uniform highp vec3 CAMERA_WORLDPOSITION;
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_REFLECTION;
uniform highp float UNIFORM_REFFACTOR;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec3 xlv_TEXCOORD2;
varying highp vec3 xlv_TEXCOORD3;
void main ()
{
  highp vec4 color_1;
  highp vec3 reflectDir_2;
  highp vec3 tmpvar_3;
  tmpvar_3 = normalize((xlv_TEXCOORD2 - CAMERA_WORLDPOSITION));
  highp vec3 tmpvar_4;
  tmpvar_4 = normalize(xlv_TEXCOORD3);
  highp vec3 tmpvar_5;
  tmpvar_5 = (tmpvar_3 - (2.0 * (
    dot (tmpvar_4, tmpvar_3)
   * tmpvar_4)));
  reflectDir_2.z = tmpvar_5.z;
  reflectDir_2.xy = ((tmpvar_5.xy * vec2(0.5, -0.5)) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (TEXTURE_REFLECTION, reflectDir_2.xy);
  color_1.xyz = (tmpvar_6 * UNIFORM_REFFACTOR).xyz;
  color_1.w = 0.0;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  highp vec4 tmpvar_8;
  tmpvar_8 = (tmpvar_7 + color_1);
  gl_FragData[0] = tmpvar_8;
}

]===],
	},
}

end
