
#DEFPARAMS
EDGE_WIDTH = { "EDGE_WIDTH", FLOAT, "1.0" },
OFFSET_SCALE = { "OFFSET_SCALE", FLOAT, "1.0" },
MIN_WIDTH = { "MIN_WIDTH", FLOAT, "1.0" },
RANGE_DISTANCE = { "RANGE_DISTANCE", FLOAT, "1.0" },
Main_Color = { "Main_Color", VEC2, "1.0,1.0,1.0,1.0" },
#END

#DEFTAG
ShaderName = "nl_4bmatrixoutline_t"
RenderQueue = "Transparent"
#END          

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_FRONT, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM

#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin

#include "common.inc"


struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float4 color : COLOR0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float4 vertex : SV_POSITION;
};

float EDGE_WIDTH;
float OFFSET_SCALE;
float MIN_WIDTH;
float RANGE_DISTANCE;
float4 Main_Color;


v2f vert(appdata v)
{
	v2f o;

	COMPUTE_BONE_MATERIX(v);

	float4 out_Position = ObjectToClipPos(v.vertex);
	float3 outNormal = ObjectToWorldNormal(v.normal).xyz;
	float r = 0.0;// v.color.r;
	float _EdgeThickness =EDGE_WIDTH*(1.0-r);
	float INV_EDGE_THICKNESS_DIVISOR =  0.00285;
	float4 projSpacePos = out_Position;
	float4 projSpaceNormal = mul(CAMERA_VIEWPROJ,float4(outNormal.xyz,0.0));
	projSpaceNormal.xy = normalize(projSpaceNormal.xy);
	float4 wpos = ObjectToWorldPos(v.vertex);
	float zcof = abs(wpos.z);
	float zmax = RANGE_DISTANCE;
	if(zcof>zmax)
	{
		zcof = zmax;
	}
	
	zcof= zcof/zmax;
	zcof =1.0-zcof;
	float widthjudge = MIN_WIDTH/EDGE_WIDTH;
	if(zcof<widthjudge)
	{
		zcof = widthjudge;
	}
	
	zcof =min(1.0,zcof);
	float4 scaledNormal = _EdgeThickness * INV_EDGE_THICKNESS_DIVISOR * projSpaceNormal*abs(wpos.z)*zcof*1.5; 
	out_Position.xy = projSpacePos.xy + scaledNormal.xy;
	float scale = 0.2;
	out_Position.z = out_Position.z+0.0003*scale*OFFSET_SCALE;

	o.vertex = out_Position;

	o.vertex = UniformNDC(o.vertex);

	return o;
}

float4 frag(v2f i) : SV_Target
{
	return Main_Color;
}
ENDCG
#END
