

#DEFPARAMS
ALPHA_FACTOR = { "Alpha Factor", FLOAT, "1.0" },
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "Lut"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D LOOKUPTABLE;
float ALPHA_FACTOR;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	#ifdef POST_EFFECT_ALPHA_OFF
		float3 rgb3 = tex2D(TEXTURE_DIFFUSE, i.uv).rgb;
		float4 rgb4 = float4(rgb3, 1.0);
		return LUT(rgb4, LOOKUPTABLE);
	#elif POST_EFFECT_ALPHA_ON
		float4 rgba = tex2D(TEXTURE_DIFFUSE, i.uv);
		float4 lrgba = LUT(rgba,LOOKUPTABLE);
		float4 res = float4(lrgba.rgb * ALPHA_FACTOR + rgba.rgb * (1.0 - ALPHA_FACTOR),rgba.a);
		return res;

	#endif
}
ENDCG
#END
