﻿

#DEFPARAMS

#END

#DEFTAG
ShaderName = "LightDot"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_DIFFUSE2;
float2 TARGETSIZE;
float UV_DOT_RADIUS;
float DOT_RADIUS;
float DOT_INTERNAL;
float UV_DOT_INTERNAL;
float ANGLE_CHANNEL;
float CONTRAST_FACTOR;
float HALF_TONE_FACTOR;
float SOFT_LIGHT_ALPHA;
float THRESHOLD;
float GRADIENT;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float aastep(float threshold, float value) {
    float uScale = CONTRAST_FACTOR * value;
    float frequency =TARGETSIZE.x*TARGETSIZE.y/(DOT_RADIUS*DOT_RADIUS);
    float afwidth = frequency * 0.01 / uScale;
    return smoothstep(threshold-afwidth, threshold+afwidth, value);
}

float4 frag(v2f i) : SV_Target
{
    //float2 TC = i.uv * TARGETSIZE;
    float2 TC = float2(i.uv.x * TARGETSIZE.x, i.uv.y * TARGETSIZE.y);
    float4 srcColor = tex2D(TEXTURE_DIFFUSE2, i.uv);
    float4 baseColor = tex2D(TEXTURE_DIFFUSE, i.uv);

    float uv2abs = 0.5 * (TARGETSIZE.x + TARGETSIZE.y);
    DOT_RADIUS = UV_DOT_RADIUS * uv2abs;
    DOT_INTERNAL = UV_DOT_INTERNAL * uv2abs;
    float rads = radians(ANGLE_CHANNEL);
    float sinRad = sin(rads);
    float cosRad = sqrt(1.0 - sinRad*sinRad);
    float2 coord = mul(TC, float2x2(cosRad, sinRad, -sinRad, cosRad));
    float2 pos = abs(fmod(coord, float2(DOT_INTERNAL.xx))) - float2(0.5 * DOT_INTERNAL.xx) + float2(DOT_RADIUS.xx);
    float radPos = length(pos-float2(DOT_RADIUS.xx));

    float4 halftoneColor;
    float luminace = srcColor.r;
    float depth = 1. - luminace;
    if(depth < THRESHOLD)
    {
        depth = 0.0;
    }
    float dr = pow(depth,abs(GRADIENT)) * DOT_RADIUS;
    float rate = aastep(dr, radPos);
    halftoneColor.r = lerp(.0, 1., rate);

    luminace = srcColor.g;
    depth = 1. - luminace;
    if(depth < THRESHOLD)
    {
        depth = 0.0;
    }
    dr = pow(depth,abs(GRADIENT)) * DOT_RADIUS;
    rate = aastep(dr, radPos);
    halftoneColor.g = lerp(.0, 1., rate);

    luminace = srcColor.b;
    depth = 1. - luminace;
    if(depth < THRESHOLD)
    {
        depth = 0.0;
    }
    dr = pow(depth,abs(GRADIENT)) * DOT_RADIUS;
    rate = aastep(dr, radPos);
    halftoneColor.b = lerp(.0, 1., rate);

    halftoneColor.a = 1.;
    halftoneColor.rgb = HALF_TONE_FACTOR * halftoneColor.rgb;

//柔光
    float4 softLight = 2.0 * baseColor * halftoneColor + baseColor*baseColor -2.0*baseColor*baseColor*halftoneColor;
    return lerp(baseColor, softLight, SOFT_LIGHT_ALPHA);
}
ENDCG
#END
