

#DEFPARAMS
#END

#DEFTAG
ShaderName = "HSLAdj"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "rgb_hsv.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float HSLADJ_HUE;
float HSLADJ_SAT;
float HSLADJ_LUM;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float3 rgb = tex2D(TEXTURE_DIFFUSE, i.uv).rgb;
    float3 hsl = hsv2hsl(rgb2hsv(rgb));
    float e = 1.0e-10;
    hsl.x = frac(hsl.x + HSLADJ_HUE + 1.0);
    if (HSLADJ_SAT >= 0.0) {
        hsl.y = 1.0 - HSLADJ_SAT <= e ? 1.0 : clamp(hsl.y / (1.0 - HSLADJ_SAT), 0.0, 1.0);
    } else {
        hsl.y = clamp(hsl.y * (1.0 + HSLADJ_SAT), 0.0, 1.0);
    }
    hsl.z = clamp(hsl.z + (1.0 - hsl.z) * HSLADJ_LUM, 0.0, 1.0);
    rgb = hsv2rgb(hsl2hsv(hsl));
    return float4(rgb, 1.0);
}
ENDCG
#END
