

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
Back_Texture = {"Video Color", TEXTURE2D, "white"},
MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},
VideoSize = {"Video Size",VEC2,"0.0,0.0"},
isUseBVTMaskTexture = { "is use BVT Mask Image", FLOAT, "0.0"},
bVisble = { "Is Visble", FLOAT, "1.0"},
roll = { "roll", FLOAT, "0.0"},
[Keywords(FIXED_HORIZONTAL_OFF, FIXED_HORIZONTAL_ON)]
_FixedHorizontal = {"FixedHorizontal", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "gpusegment_mask"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile FIXED_HORIZONTAL_OFF FIXED_HORIZONTAL_ON
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float4 uv : TEXCOORD0;
	float4 screenPos : TEXCOORD1;
	float reliability: TEXCOORD2;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D Back_Texture;
float4 MaskInfo;
float2 VideoSize;
float isUseBVTMaskTexture;
float bVisble;
float roll;

v2f vert(appdata v)
{
	v2f o = (v2f)0;
	//计算Mesh纹理的uv坐标
	if(isUseBVTMaskTexture > 0.1)
	{
		o.uv = float4(v.uv.x,v.uv.y,0.0,1.0);
	}

	o.reliability = v.vertex.z;

	#ifdef FIXED_HORIZONTAL_ON
	float Rotation_x = v.vertex.x*cos(roll) - v.vertex.y*sin(roll);
	float Rotation_y = v.vertex.x*sin(roll) + v.vertex.y*cos(roll);
    
	float newx = (Rotation_x - MaskInfo.x) /MaskInfo.z * 2.0 - 1.0;
	float newy = (Rotation_y - MaskInfo.y) /MaskInfo.w * 2.0 - 1.0;
    #else
	float newx = (v.vertex.x - MaskInfo.x) /MaskInfo.z * 2.0 - 1.0;
	float newy = (v.vertex.y - MaskInfo.y) /MaskInfo.w * 2.0 - 1.0;
	#endif

	float4 pos = float4(newx ,-newy,0.0,1.0);
	//pos = mul(LOCALWORLD_TRANSFORM, pos);
	o.screenPos = float4(v.vertex.x,v.vertex.y,0.0,1.0);
	
	o.vertex = UniformNDC(pos);
	return o;
}
float2 clamp_to_edge(float2 uv)
{
	float2 uv_clamp;
	float min = 0.001;
	float max = 0.999;
	uv_clamp.x  = uv.x >= max ? max:uv.x;
	uv_clamp.x  = uv_clamp.x <= min ? min:uv_clamp.x;
	
	uv_clamp.y  = uv.y >= max ? max:uv.y;
	uv_clamp.y  = uv_clamp.y <= min ? min:uv_clamp.y;
	return uv_clamp;
}

float4 frag(v2f i) : SV_Target
{
	float2 uvCoord = i.screenPos.xy/VideoSize;

	float4 backColor = tex2D(Back_Texture,clamp_to_edge(uvCoord));
	if(isUseBVTMaskTexture > 0.1)
	{	
		float4 bvtMaskImageColor = tex2D(TEXTURE_DIFFUSE, i.uv);
		backColor.a = bvtMaskImageColor.a * i.reliability * bVisble;
	}
	else
	{
		backColor.a = i.reliability * bVisble;	
	}

	return backColor;
}
ENDCG
#END
