

function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
Back_Texture = {"Video Color", TEXTURE2D, "white"},
MaskInfo = {"MaskInfo",VEC4,"0.0,0.0,0.0,0.0"},
VideoSize = {"Video Size",VEC2,"0.0,0.0"},
isUseBVTMaskTexture = { "is use BVT Mask Image", FLOAT, "0.0"},
bVisble = { "Is Visble", FLOAT, "1.0"},
roll = { "roll", FLOAT, "0.0"},

_FixedHorizontal = {"FixedHorizontal", FLOAT, "0.0"},

	}
	Attributes = 
	{
		_FixedHorizontal = "Keywords(FIXED_HORIZONTAL_OFF,FIXED_HORIZONTAL_ON)", 
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "gpusegment_mask"
RenderQueue = "Transparent+1"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {"FIXED_HORIZONTAL_OFF"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "isUseBVTMaskTexture",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Back_Texture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "isUseBVTMaskTexture",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "bVisble",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 MaskInfo;
uniform highp float isUseBVTMaskTexture;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp float xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  if ((isUseBVTMaskTexture > 0.1)) {
    highp vec4 tmpvar_5;
    tmpvar_5.zw = vec2(0.0, 1.0);
    tmpvar_5.xy = tmpvar_2;
    tmpvar_3 = tmpvar_5;
  };
  tmpvar_4 = tmpvar_1.z;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  tmpvar_6.x = (((
    (_glesVertex.x - MaskInfo.x)
   / MaskInfo.z) * 2.0) - 1.0);
  tmpvar_6.y = (1.0 - ((
    (_glesVertex.y - MaskInfo.y)
   / MaskInfo.w) * 2.0));
  highp vec4 tmpvar_7;
  tmpvar_7.zw = vec2(0.0, 1.0);
  tmpvar_7.xy = tmpvar_1.xy;
  highp vec4 tmpvar_8;
  tmpvar_8.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_8.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_8 * tmpvar_6);
  xlv_TEXCOORD0 = tmpvar_3;
  xlv_TEXCOORD1 = tmpvar_7;
  xlv_TEXCOORD2 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D Back_Texture;
uniform highp vec2 VideoSize;
uniform highp float isUseBVTMaskTexture;
uniform highp float bVisble;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp float xlv_TEXCOORD2;
void main ()
{
  highp vec4 backColor_1;
  highp vec2 tmpvar_2;
  tmpvar_2 = (xlv_TEXCOORD1.xy / VideoSize);
  highp vec2 uv_clamp_3;
  highp float tmpvar_4;
  if ((tmpvar_2.x >= 0.999)) {
    tmpvar_4 = 0.999;
  } else {
    tmpvar_4 = tmpvar_2.x;
  };
  uv_clamp_3.x = tmpvar_4;
  highp float tmpvar_5;
  if ((tmpvar_4 <= 0.001)) {
    tmpvar_5 = 0.001;
  } else {
    tmpvar_5 = uv_clamp_3.x;
  };
  uv_clamp_3.x = tmpvar_5;
  highp float tmpvar_6;
  if ((tmpvar_2.y >= 0.999)) {
    tmpvar_6 = 0.999;
  } else {
    tmpvar_6 = tmpvar_2.y;
  };
  uv_clamp_3.y = tmpvar_6;
  highp float tmpvar_7;
  if ((tmpvar_6 <= 0.001)) {
    tmpvar_7 = 0.001;
  } else {
    tmpvar_7 = uv_clamp_3.y;
  };
  uv_clamp_3.y = tmpvar_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (Back_Texture, uv_clamp_3);
  backColor_1 = tmpvar_8;
  if ((isUseBVTMaskTexture > 0.1)) {
    highp vec4 bvtMaskImageColor_9;
    lowp vec4 tmpvar_10;
    tmpvar_10 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0.xy);
    bvtMaskImageColor_9 = tmpvar_10;
    backColor_1.w = ((bvtMaskImageColor_9.w * xlv_TEXCOORD2) * bVisble);
  } else {
    backColor_1.w = (xlv_TEXCOORD2 * bVisble);
  };
  _glesFragData[0] = backColor_1;
}

]===],
	},
	{
		shaderApi = "gles3",
		keyWords = {"FIXED_HORIZONTAL_ON"},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MaskInfo",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "isUseBVTMaskTexture",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "roll",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "Back_Texture",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "VideoSize",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "isUseBVTMaskTexture",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "bVisble",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 MaskInfo;
uniform highp float isUseBVTMaskTexture;
uniform highp float roll;
out highp vec4 xlv_TEXCOORD0;
out highp vec4 xlv_TEXCOORD1;
out highp float xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 tmpvar_2;
  tmpvar_2 = _glesMultiTexCoord0.xy;
  highp vec4 tmpvar_3;
  highp float tmpvar_4;
  tmpvar_3 = vec4(0.0, 0.0, 0.0, 0.0);
  tmpvar_4 = 0.0;
  if ((isUseBVTMaskTexture > 0.1)) {
    highp vec4 tmpvar_5;
    tmpvar_5.zw = vec2(0.0, 1.0);
    tmpvar_5.xy = tmpvar_2;
    tmpvar_3 = tmpvar_5;
  };
  tmpvar_4 = tmpvar_1.z;
  highp vec4 tmpvar_6;
  tmpvar_6.zw = vec2(0.0, 1.0);
  highp float tmpvar_7;
  tmpvar_7 = sin(roll);
  highp float tmpvar_8;
  tmpvar_8 = cos(roll);
  tmpvar_6.x = (((
    (((_glesVertex.x * tmpvar_8) - (_glesVertex.y * tmpvar_7)) - MaskInfo.x)
   / MaskInfo.z) * 2.0) - 1.0);
  tmpvar_6.y = (1.0 - ((
    (((_glesVertex.x * tmpvar_7) + (_glesVertex.y * tmpvar_8)) - MaskInfo.y)
   / MaskInfo.w) * 2.0));
  highp vec4 tmpvar_9;
  tmpvar_9.zw = vec2(0.0, 1.0);
  tmpvar_9.xy = tmpvar_1.xy;
  highp vec4 tmpvar_10;
  tmpvar_10.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_10.y = DEVICE_COORDINATE_Y_FLIP;
  gl_Position = (tmpvar_10 * tmpvar_6);
  xlv_TEXCOORD0 = tmpvar_3;
  xlv_TEXCOORD1 = tmpvar_9;
  xlv_TEXCOORD2 = tmpvar_4;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D Back_Texture;
uniform highp vec2 VideoSize;
uniform highp float isUseBVTMaskTexture;
uniform highp float bVisble;
in highp vec4 xlv_TEXCOORD0;
in highp vec4 xlv_TEXCOORD1;
in highp float xlv_TEXCOORD2;
void main ()
{
  highp vec4 backColor_1;
  highp vec2 tmpvar_2;
  tmpvar_2 = (xlv_TEXCOORD1.xy / VideoSize);
  highp vec2 uv_clamp_3;
  highp float tmpvar_4;
  if ((tmpvar_2.x >= 0.999)) {
    tmpvar_4 = 0.999;
  } else {
    tmpvar_4 = tmpvar_2.x;
  };
  uv_clamp_3.x = tmpvar_4;
  highp float tmpvar_5;
  if ((tmpvar_4 <= 0.001)) {
    tmpvar_5 = 0.001;
  } else {
    tmpvar_5 = uv_clamp_3.x;
  };
  uv_clamp_3.x = tmpvar_5;
  highp float tmpvar_6;
  if ((tmpvar_2.y >= 0.999)) {
    tmpvar_6 = 0.999;
  } else {
    tmpvar_6 = tmpvar_2.y;
  };
  uv_clamp_3.y = tmpvar_6;
  highp float tmpvar_7;
  if ((tmpvar_6 <= 0.001)) {
    tmpvar_7 = 0.001;
  } else {
    tmpvar_7 = uv_clamp_3.y;
  };
  uv_clamp_3.y = tmpvar_7;
  lowp vec4 tmpvar_8;
  tmpvar_8 = texture (Back_Texture, uv_clamp_3);
  backColor_1 = tmpvar_8;
  if ((isUseBVTMaskTexture > 0.1)) {
    highp vec4 bvtMaskImageColor_9;
    lowp vec4 tmpvar_10;
    tmpvar_10 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0.xy);
    bvtMaskImageColor_9 = tmpvar_10;
    backColor_1.w = ((bvtMaskImageColor_9.w * xlv_TEXCOORD2) * bVisble);
  } else {
    backColor_1.w = (xlv_TEXCOORD2 * bVisble);
  };
  _glesFragData[0] = backColor_1;
}

]===],
	},
}

end
