

#DEFPARAMS
PIXEL_SIZE = { "PixelSize", VEC2, "1.0,1.0" },
DOWNSAMPLE_FACTOR = { "Downsample Factor", VEC2, "1.0,1.0" },
THRESHOLD = { "THRESHOLD", FLOAT, "1.0" },
[Keywords(RGB, GRAY, BINARY)]
OUT_TYPE = {"OUT_TYPE", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "downsample"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile RGB GRAY BINARY
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 PIXEL_SIZE;
float2 DOWNSAMPLE_FACTOR ;
float THRESHOLD;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;
	return o;
}

float4 frag(v2f i) : SV_Target
{
    int patchSize_x = 1 / DOWNSAMPLE_FACTOR .x;
    int patchSize_y = 1 / DOWNSAMPLE_FACTOR .y;
    float3 weights = float3(0.2125,0.7154,0.0721);
    float2 texcoord_sample;
    float4 color = float4(0.0, 0.0, 0.0, 0.0);
  
    for(int col = 0; col < patchSize_x; col++)
    {
         texcoord_sample.x  = i.uv.x + (col - patchSize_x/2) * PIXEL_SIZE.x;
         if(texcoord_sample.x < 0)
             texcoord_sample.x = 0.0;

         if(texcoord_sample.x > 1.0)
             texcoord_sample.x = 1.0;
        
        for(int row = 0; row < patchSize_y; row++)
        {
            texcoord_sample.y  = i.uv.y + (row - patchSize_y/2) * PIXEL_SIZE.y;
            if(texcoord_sample.y < 0)
              texcoord_sample.y = 0.0;

            if(texcoord_sample.y > 1.0)
              texcoord_sample.y = 1.0;

            #ifdef RGB
            color += tex2D(TEXTURE_DIFFUSE, texcoord_sample);
            #elif GRAY
            float Intensity = dot(tex2D(TEXTURE_DIFFUSE, texcoord_sample).rgb, weights);
            color += float4(Intensity, Intensity, Intensity, 1.0);
            #elif BINARY
            float Intensity = dot(tex2D(TEXTURE_DIFFUSE, texcoord_sample).rgb, weights);
            color += float4(Intensity, Intensity, Intensity, 1.0);
            #endif           
        }
    }

    color = color /(patchSize_x * patchSize_y);

    #ifdef BINARY
    float val = step(THRESHOLD, color.r);
    color = float4(val, val, val, 1.0);
    #endif
    
    return color;
}
ENDCG
#END
