

#DEFPARAMS
#END

#DEFTAG
ShaderName = "DisenyFace"
RenderQueue = "Transparent"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
// #include "utils.inc"

struct appdata   
{
	float3 vertex : POSITION;
	float2 uv1 : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv1 : TEXCOORD0;
};

sampler2D TEXTURE_GAN;
float4x4 PARAMS;
float2 ganSize;
float2 srcSize;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = float4(v.vertex,1.0);
	
    o.vertex.xy = float2((v.vertex.x) / srcSize.x * 2.0 - 1.0, (1-v.vertex.y / srcSize.y) * 2.0 - 1.0);

	o.vertex = UniformNDC(o.vertex);
	
	o.uv1 = float2(v.uv1.x / ganSize.x, 1 - v.uv1.y / ganSize.y);
	return o;
}


float4 frag(v2f i) : SV_Target
{

    float4 genColor = tex2D(TEXTURE_GAN,i.uv1);
    float alpha = genColor.a;
  
    float4 col = float4(genColor.rgb,alpha);
  
	
  return col;
}
ENDCG
#END
